@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes header information for http route matching.
 * @property name Name of header to match in request.
 * @property type how to match header value
 * @property value Value of header to match in request.
 */
public data class HttpRouteMatchHeaderResponse(
    public val name: String,
    public val type: String? = null,
    public val `value`: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicefabricmesh.outputs.HttpRouteMatchHeaderResponse): HttpRouteMatchHeaderResponse = HttpRouteMatchHeaderResponse(
            name = javaType.name(),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
            `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
        )
    }
}
