@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes properties of a network resource.
 * @property description User readable description of the network.
 * @property kind The type of a Service Fabric container network.
 * Expected value is 'NetworkResourceProperties'.
 * @property provisioningState State of the resource.
 * @property status Status of the network.
 * @property statusDetails Gives additional information about the current status of the network.
 */
public data class NetworkResourcePropertiesResponse(
    public val description: String? = null,
    public val kind: String,
    public val provisioningState: String,
    public val status: String,
    public val statusDetails: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicefabricmesh.outputs.NetworkResourcePropertiesResponse): NetworkResourcePropertiesResponse = NetworkResourcePropertiesResponse(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            kind = javaType.kind(),
            provisioningState = javaType.provisioningState(),
            status = javaType.status(),
            statusDetails = javaType.statusDetails(),
        )
    }
}
