@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Specifying this parameter adds support for reliable collections
 * @property doNotPersistState False (the default) if ReliableCollections state is persisted to disk as usual. True if you do not want to persist state, in which case replication is still enabled and you can use ReliableCollections as distributed cache.
 * @property name Name of ReliableCollection resource. Right now it's not used and you can use any string.
 */
public data class ReliableCollectionsRefResponse(
    public val doNotPersistState: Boolean? = null,
    public val name: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicefabricmesh.outputs.ReliableCollectionsRefResponse): ReliableCollectionsRefResponse = ReliableCollectionsRefResponse(
            doNotPersistState = javaType.doNotPersistState().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
        )
    }
}
