@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin.outputs

import kotlin.Double
import kotlin.Suppress

/**
 * This type describes the requested resources for a given container. It describes the least amount of resources required for the container. A container can consume more than requested resources up to the specified limits before being restarted. Currently, the requested resources are treated as limits.
 * @property cpu Requested number of CPU cores. At present, only full cores are supported.
 * @property memoryInGB The memory request in GB for this container.
 */
public data class ResourceRequestsResponse(
    public val cpu: Double,
    public val memoryInGB: Double,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicefabricmesh.outputs.ResourceRequestsResponse): ResourceRequestsResponse = ResourceRequestsResponse(
            cpu = javaType.cpu(),
            memoryInGB = javaType.memoryInGB(),
        )
    }
}
