@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin.outputs

import kotlin.Suppress

/**
 * This type describes the resource requirements for a container or a service.
 * @property limits Describes the maximum limits on the resources for a given container.
 * @property requests Describes the requested resources for a given container.
 */
public data class ResourceRequirementsResponse(
    public val limits: ResourceLimitsResponse? = null,
    public val requests: ResourceRequestsResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicefabricmesh.outputs.ResourceRequirementsResponse): ResourceRequirementsResponse = ResourceRequirementsResponse(
            limits = javaType.limits().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.servicefabricmesh.kotlin.outputs.ResourceLimitsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            requests = javaType.requests().let({ args0 ->
                com.pulumi.azurenative.servicefabricmesh.kotlin.outputs.ResourceRequestsResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
