@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * This type describes a service resource.
 * @property autoScalingPolicies Auto scaling policies
 * @property codePackages Describes the set of code packages that forms the service. A code package describes the container and the properties for running it. All the code packages are started together on the same host and share the same context (network, process etc.).
 * @property description User readable description of the service.
 * @property diagnostics Reference to sinks in DiagnosticsDescription.
 * @property healthState Describes the health state of an application resource.
 * @property id Fully qualified identifier for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property networkRefs The names of the private networks that this service needs to be part of.
 * @property osType The operation system required by the code in service.
 * @property provisioningState State of the resource.
 * @property replicaCount The number of replicas of the service to create. Defaults to 1 if not specified.
 * @property status Status of the service.
 * @property statusDetails Gives additional information about the current status of the service.
 * @property type The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
 * @property unhealthyEvaluation When the service's health state is not 'Ok', this additional details from service fabric Health Manager for the user to know why the service is marked unhealthy.
 */
public data class ServiceResourceDescriptionResponse(
    public val autoScalingPolicies: List<AutoScalingPolicyResponse>? = null,
    public val codePackages: List<ContainerCodePackagePropertiesResponse>,
    public val description: String? = null,
    public val diagnostics: DiagnosticsRefResponse? = null,
    public val healthState: String,
    public val id: String,
    public val name: String? = null,
    public val networkRefs: List<NetworkRefResponse>? = null,
    public val osType: String,
    public val provisioningState: String,
    public val replicaCount: Int? = null,
    public val status: String,
    public val statusDetails: String,
    public val type: String,
    public val unhealthyEvaluation: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicefabricmesh.outputs.ServiceResourceDescriptionResponse): ServiceResourceDescriptionResponse = ServiceResourceDescriptionResponse(
            autoScalingPolicies = javaType.autoScalingPolicies().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.servicefabricmesh.kotlin.outputs.AutoScalingPolicyResponse.Companion.toKotlin(args0)
                })
            }),
            codePackages = javaType.codePackages().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.servicefabricmesh.kotlin.outputs.ContainerCodePackagePropertiesResponse.Companion.toKotlin(args0)
                })
            }),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            diagnostics = javaType.diagnostics().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.servicefabricmesh.kotlin.outputs.DiagnosticsRefResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            healthState = javaType.healthState(),
            id = javaType.id(),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            networkRefs = javaType.networkRefs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.servicefabricmesh.kotlin.outputs.NetworkRefResponse.Companion.toKotlin(args0)
                })
            }),
            osType = javaType.osType(),
            provisioningState = javaType.provisioningState(),
            replicaCount = javaType.replicaCount().map({ args0 -> args0 }).orElse(null),
            status = javaType.status(),
            statusDetails = javaType.statusDetails(),
            type = javaType.type(),
            unhealthyEvaluation = javaType.unhealthyEvaluation(),
        )
    }
}
