@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * This type describes a volume provided by an Azure Files file share.
 * @property accountKey Access key of the Azure storage account for the File Share.
 * @property accountName Name of the Azure storage account for the File Share.
 * @property shareName Name of the Azure Files file share that provides storage for the volume.
 */
public data class VolumeProviderParametersAzureFileResponse(
    public val accountKey: String? = null,
    public val accountName: String,
    public val shareName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicefabricmesh.outputs.VolumeProviderParametersAzureFileResponse): VolumeProviderParametersAzureFileResponse = VolumeProviderParametersAzureFileResponse(
            accountKey = javaType.accountKey().map({ args0 -> args0 }).orElse(null),
            accountName = javaType.accountName(),
            shareName = javaType.shareName(),
        )
    }
}
