@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicelinker.kotlin

import com.pulumi.azurenative.servicelinker.kotlin.outputs.ConfigurationInfoResponse
import com.pulumi.azurenative.servicelinker.kotlin.outputs.PublicNetworkSolutionResponse
import com.pulumi.azurenative.servicelinker.kotlin.outputs.SecretStoreResponse
import com.pulumi.azurenative.servicelinker.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.servicelinker.kotlin.outputs.VNetSolutionResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.servicelinker.kotlin.outputs.ConfigurationInfoResponse.Companion.toKotlin as configurationInfoResponseToKotlin
import com.pulumi.azurenative.servicelinker.kotlin.outputs.PublicNetworkSolutionResponse.Companion.toKotlin as publicNetworkSolutionResponseToKotlin
import com.pulumi.azurenative.servicelinker.kotlin.outputs.SecretStoreResponse.Companion.toKotlin as secretStoreResponseToKotlin
import com.pulumi.azurenative.servicelinker.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin
import com.pulumi.azurenative.servicelinker.kotlin.outputs.VNetSolutionResponse.Companion.toKotlin as vNetSolutionResponseToKotlin

/**
 * Builder for [Connector].
 */
@PulumiTagMarker
public class ConnectorResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ConnectorArgs = ConnectorArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ConnectorArgsBuilder.() -> Unit) {
        val builder = ConnectorArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Connector {
        val builtJavaResource = com.pulumi.azurenative.servicelinker.Connector(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Connector(builtJavaResource)
    }
}

/**
 * Linker of source and target resource
 * Azure REST API version: 2022-11-01-preview.
 * Other available API versions: 2023-04-01-preview, 2024-04-01.
 * ## Example Usage
 * ### PutConnector
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var connector = new AzureNative.ServiceLinker.Connector("connector", new()
 *     {
 *         AuthInfo = new AzureNative.ServiceLinker.Inputs.SecretAuthInfoArgs
 *         {
 *             AuthType = "secret",
 *         },
 *         ConnectorName = "connectorName",
 *         Location = "westus",
 *         ResourceGroupName = "test-rg",
 *         SecretStore = new AzureNative.ServiceLinker.Inputs.SecretStoreArgs
 *         {
 *             KeyVaultId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/test-rg/providers/Microsoft.KeyVault/vaults/test-kv",
 *         },
 *         TargetService = new AzureNative.ServiceLinker.Inputs.AzureResourceArgs
 *         {
 *             Id = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/test-rg/providers/Microsoft.DocumentDb/databaseAccounts/test-acc/mongodbDatabases/test-db",
 *             Type = "AzureResource",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/servicelinker/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicelinker.NewConnector(ctx, "connector", &servicelinker.ConnectorArgs{
 * 			AuthInfo: servicelinker.SecretAuthInfo{
 * 				AuthType: "secret",
 * 			},
 * 			ConnectorName:     pulumi.String("connectorName"),
 * 			Location:          pulumi.String("westus"),
 * 			ResourceGroupName: pulumi.String("test-rg"),
 * 			SecretStore: &servicelinker.SecretStoreArgs{
 * 				KeyVaultId: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/test-rg/providers/Microsoft.KeyVault/vaults/test-kv"),
 * 			},
 * 			TargetService: servicelinker.AzureResource{
 * 				Id:   "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/test-rg/providers/Microsoft.DocumentDb/databaseAccounts/test-acc/mongodbDatabases/test-db",
 * 				Type: "AzureResource",
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.servicelinker.Connector;
 * import com.pulumi.azurenative.servicelinker.ConnectorArgs;
 * import com.pulumi.azurenative.servicelinker.inputs.SecretStoreArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var connector = new Connector("connector", ConnectorArgs.builder()
 *             .authInfo(AccessKeyInfoBaseArgs.builder()
 *                 .authType("secret")
 *                 .build())
 *             .connectorName("connectorName")
 *             .location("westus")
 *             .resourceGroupName("test-rg")
 *             .secretStore(SecretStoreArgs.builder()
 *                 .keyVaultId("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/test-rg/providers/Microsoft.KeyVault/vaults/test-kv")
 *                 .build())
 *             .targetService(AzureResourceArgs.builder()
 *                 .id("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/test-rg/providers/Microsoft.DocumentDb/databaseAccounts/test-acc/mongodbDatabases/test-db")
 *                 .type("AzureResource")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:servicelinker:Connector linkName /subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.ServiceLinker/locations/{location}/connectors/{connectorName}
 * ```
 */
public class Connector internal constructor(
    override val javaResource: com.pulumi.azurenative.servicelinker.Connector,
) : KotlinCustomResource(javaResource, ConnectorMapper) {
    /**
     * The authentication type.
     */
    public val authInfo: Output<Any>?
        get() = javaResource.authInfo().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The application client type
     */
    public val clientType: Output<String>?
        get() = javaResource.clientType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The connection information consumed by applications, including secrets, connection strings.
     */
    public val configurationInfo: Output<ConfigurationInfoResponse>?
        get() = javaResource.configurationInfo().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> configurationInfoResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The network solution.
     */
    public val publicNetworkSolution: Output<PublicNetworkSolutionResponse>?
        get() = javaResource.publicNetworkSolution().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> publicNetworkSolutionResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * connection scope in source service.
     */
    public val scope: Output<String>?
        get() = javaResource.scope().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * An option to store secret value in secure place
     */
    public val secretStore: Output<SecretStoreResponse>?
        get() = javaResource.secretStore().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    secretStoreResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The target service properties
     */
    public val targetService: Output<Any>?
        get() = javaResource.targetService().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The VNet solution.
     */
    public val vNetSolution: Output<VNetSolutionResponse>?
        get() = javaResource.vNetSolution().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    vNetSolutionResponseToKotlin(args0)
                })
            }).orElse(null)
        })
}

public object ConnectorMapper : ResourceMapper<Connector> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.servicelinker.Connector::class == javaResource::class

    override fun map(javaResource: Resource): Connector = Connector(
        javaResource as
            com.pulumi.azurenative.servicelinker.Connector,
    )
}

/**
 * @see [Connector].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Connector].
 */
public suspend fun connector(name: String, block: suspend ConnectorResourceBuilder.() -> Unit): Connector {
    val builder = ConnectorResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Connector].
 * @param name The _unique_ name of the resulting resource.
 */
public fun connector(name: String): Connector {
    val builder = ConnectorResourceBuilder()
    builder.name(name)
    return builder.build()
}
