@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicelinker.kotlin

import com.pulumi.azurenative.servicelinker.kotlin.outputs.ConfigurationInfoResponse
import com.pulumi.azurenative.servicelinker.kotlin.outputs.PublicNetworkSolutionResponse
import com.pulumi.azurenative.servicelinker.kotlin.outputs.SecretStoreResponse
import com.pulumi.azurenative.servicelinker.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.servicelinker.kotlin.outputs.VNetSolutionResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.servicelinker.kotlin.outputs.ConfigurationInfoResponse.Companion.toKotlin as configurationInfoResponseToKotlin
import com.pulumi.azurenative.servicelinker.kotlin.outputs.PublicNetworkSolutionResponse.Companion.toKotlin as publicNetworkSolutionResponseToKotlin
import com.pulumi.azurenative.servicelinker.kotlin.outputs.SecretStoreResponse.Companion.toKotlin as secretStoreResponseToKotlin
import com.pulumi.azurenative.servicelinker.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin
import com.pulumi.azurenative.servicelinker.kotlin.outputs.VNetSolutionResponse.Companion.toKotlin as vNetSolutionResponseToKotlin

/**
 * Builder for [Linker].
 */
@PulumiTagMarker
public class LinkerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LinkerArgs = LinkerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LinkerArgsBuilder.() -> Unit) {
        val builder = LinkerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Linker {
        val builtJavaResource = com.pulumi.azurenative.servicelinker.Linker(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Linker(builtJavaResource)
    }
}

/**
 * Linker of source and target resource
 * Azure REST API version: 2022-11-01-preview. Prior API version in Azure Native 1.x: 2021-11-01-preview.
 * Other available API versions: 2021-11-01-preview, 2023-04-01-preview, 2024-04-01.
 * ## Example Usage
 * ### PutLinker
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var linker = new AzureNative.ServiceLinker.Linker("linker", new()
 *     {
 *         AuthInfo = new AzureNative.ServiceLinker.Inputs.SecretAuthInfoArgs
 *         {
 *             AuthType = "secret",
 *             Name = "name",
 *             SecretInfo = new AzureNative.ServiceLinker.Inputs.ValueSecretInfoArgs
 *             {
 *                 SecretType = "rawValue",
 *                 Value = "secret",
 *             },
 *         },
 *         LinkerName = "linkName",
 *         ResourceUri = "subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/test-rg/providers/Microsoft.Web/sites/test-app",
 *         TargetService = new AzureNative.ServiceLinker.Inputs.AzureResourceArgs
 *         {
 *             Id = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/test-rg/providers/Microsoft.DBforPostgreSQL/servers/test-pg/databases/test-db",
 *             Type = "AzureResource",
 *         },
 *         VNetSolution = new AzureNative.ServiceLinker.Inputs.VNetSolutionArgs
 *         {
 *             Type = AzureNative.ServiceLinker.VNetSolutionType.ServiceEndpoint,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/servicelinker/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicelinker.NewLinker(ctx, "linker", &servicelinker.LinkerArgs{
 * 			AuthInfo: servicelinker.SecretAuthInfo{
 * 				AuthType: "secret",
 * 				Name:     "name",
 * 				SecretInfo: servicelinker.ValueSecretInfo{
 * 					SecretType: "rawValue",
 * 					Value:      "secret",
 * 				},
 * 			},
 * 			LinkerName:  pulumi.String("linkName"),
 * 			ResourceUri: pulumi.String("subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/test-rg/providers/Microsoft.Web/sites/test-app"),
 * 			TargetService: servicelinker.AzureResource{
 * 				Id:   "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/test-rg/providers/Microsoft.DBforPostgreSQL/servers/test-pg/databases/test-db",
 * 				Type: "AzureResource",
 * 			},
 * 			VNetSolution: &servicelinker.VNetSolutionArgs{
 * 				Type: pulumi.String(servicelinker.VNetSolutionTypeServiceEndpoint),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.servicelinker.Linker;
 * import com.pulumi.azurenative.servicelinker.LinkerArgs;
 * import com.pulumi.azurenative.servicelinker.inputs.VNetSolutionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var linker = new Linker("linker", LinkerArgs.builder()
 *             .authInfo(AccessKeyInfoBaseArgs.builder()
 *                 .authType("secret")
 *                 .name("name")
 *                 .secretInfo(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *                 .build())
 *             .linkerName("linkName")
 *             .resourceUri("subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/test-rg/providers/Microsoft.Web/sites/test-app")
 *             .targetService(AzureResourceArgs.builder()
 *                 .id("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/test-rg/providers/Microsoft.DBforPostgreSQL/servers/test-pg/databases/test-db")
 *                 .type("AzureResource")
 *                 .build())
 *             .vNetSolution(VNetSolutionArgs.builder()
 *                 .type("serviceEndpoint")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:servicelinker:Linker linkName /{resourceUri}/providers/Microsoft.ServiceLinker/linkers/{linkerName}
 * ```
 */
public class Linker internal constructor(
    override val javaResource: com.pulumi.azurenative.servicelinker.Linker,
) : KotlinCustomResource(javaResource, LinkerMapper) {
    /**
     * The authentication type.
     */
    public val authInfo: Output<Any>?
        get() = javaResource.authInfo().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The application client type
     */
    public val clientType: Output<String>?
        get() = javaResource.clientType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The connection information consumed by applications, including secrets, connection strings.
     */
    public val configurationInfo: Output<ConfigurationInfoResponse>?
        get() = javaResource.configurationInfo().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> configurationInfoResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The network solution.
     */
    public val publicNetworkSolution: Output<PublicNetworkSolutionResponse>?
        get() = javaResource.publicNetworkSolution().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> publicNetworkSolutionResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * connection scope in source service.
     */
    public val scope: Output<String>?
        get() = javaResource.scope().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * An option to store secret value in secure place
     */
    public val secretStore: Output<SecretStoreResponse>?
        get() = javaResource.secretStore().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    secretStoreResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The target service properties
     */
    public val targetService: Output<Any>?
        get() = javaResource.targetService().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The VNet solution.
     */
    public val vNetSolution: Output<VNetSolutionResponse>?
        get() = javaResource.vNetSolution().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    vNetSolutionResponseToKotlin(args0)
                })
            }).orElse(null)
        })
}

public object LinkerMapper : ResourceMapper<Linker> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.servicelinker.Linker::class == javaResource::class

    override fun map(javaResource: Resource): Linker = Linker(
        javaResource as
            com.pulumi.azurenative.servicelinker.Linker,
    )
}

/**
 * @see [Linker].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Linker].
 */
public suspend fun linker(name: String, block: suspend LinkerResourceBuilder.() -> Unit): Linker {
    val builder = LinkerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Linker].
 * @param name The _unique_ name of the resulting resource.
 */
public fun linker(name: String): Linker {
    val builder = LinkerResourceBuilder()
    builder.name(name)
    return builder.build()
}
