@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicelinker.kotlin

import com.pulumi.azurenative.servicelinker.LinkerDryrunArgs.builder
import com.pulumi.azurenative.servicelinker.kotlin.inputs.CreateOrUpdateDryrunParametersArgs
import com.pulumi.azurenative.servicelinker.kotlin.inputs.CreateOrUpdateDryrunParametersArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * a dryrun job resource
 * Azure REST API version: 2022-11-01-preview.
 * Other available API versions: 2023-04-01-preview, 2024-04-01.
 * ## Example Usage
 * ### PutDryrun
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var linkerDryrun = new AzureNative.ServiceLinker.LinkerDryrun("linkerDryrun", new()
 *     {
 *         DryrunName = "dryrunName",
 *         Parameters = new AzureNative.ServiceLinker.Inputs.CreateOrUpdateDryrunParametersArgs
 *         {
 *             ActionName = "createOrUpdate",
 *             AuthInfo = new AzureNative.ServiceLinker.Inputs.SecretAuthInfoArgs
 *             {
 *                 AuthType = "secret",
 *                 Name = "name",
 *                 SecretInfo = new AzureNative.ServiceLinker.Inputs.ValueSecretInfoArgs
 *                 {
 *                     SecretType = "rawValue",
 *                     Value = "secret",
 *                 },
 *             },
 *             TargetService = new AzureNative.ServiceLinker.Inputs.AzureResourceArgs
 *             {
 *                 Id = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/test-rg/providers/Microsoft.DocumentDb/databaseAccounts/test-acc/mongodbDatabases/test-db",
 *                 Type = "AzureResource",
 *             },
 *         },
 *         ResourceUri = "subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/test-rg/providers/Microsoft.Web/sites/test-app",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/servicelinker/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicelinker.NewLinkerDryrun(ctx, "linkerDryrun", &servicelinker.LinkerDryrunArgs{
 * 			DryrunName: pulumi.String("dryrunName"),
 * 			Parameters: &servicelinker.CreateOrUpdateDryrunParametersArgs{
 * 				ActionName: pulumi.String("createOrUpdate"),
 * 				AuthInfo: servicelinker.SecretAuthInfo{
 * 					AuthType: "secret",
 * 					Name:     "name",
 * 					SecretInfo: servicelinker.ValueSecretInfo{
 * 						SecretType: "rawValue",
 * 						Value:      "secret",
 * 					},
 * 				},
 * 				TargetService: servicelinker.AzureResource{
 * 					Id:   "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/test-rg/providers/Microsoft.DocumentDb/databaseAccounts/test-acc/mongodbDatabases/test-db",
 * 					Type: "AzureResource",
 * 				},
 * 			},
 * 			ResourceUri: pulumi.String("subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/test-rg/providers/Microsoft.Web/sites/test-app"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.servicelinker.LinkerDryrun;
 * import com.pulumi.azurenative.servicelinker.LinkerDryrunArgs;
 * import com.pulumi.azurenative.servicelinker.inputs.CreateOrUpdateDryrunParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var linkerDryrun = new LinkerDryrun("linkerDryrun", LinkerDryrunArgs.builder()
 *             .dryrunName("dryrunName")
 *             .parameters(CreateOrUpdateDryrunParametersArgs.builder()
 *                 .actionName("createOrUpdate")
 *                 .authInfo(AccessKeyInfoBaseArgs.builder()
 *                     .authType("secret")
 *                     .name("name")
 *                     .secretInfo(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *                     .build())
 *                 .targetService(AzureResourceArgs.builder()
 *                     .id("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/test-rg/providers/Microsoft.DocumentDb/databaseAccounts/test-acc/mongodbDatabases/test-db")
 *                     .type("AzureResource")
 *                     .build())
 *                 .build())
 *             .resourceUri("subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/test-rg/providers/Microsoft.Web/sites/test-app")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:servicelinker:LinkerDryrun dryrunName /{resourceUri}/providers/Microsoft.ServiceLinker/dryruns/{dryrunName}
 * ```
 * @property dryrunName The name of dryrun.
 * @property parameters The parameters of the dryrun
 * @property resourceUri The fully qualified Azure Resource manager identifier of the resource to be connected.
 */
public data class LinkerDryrunArgs(
    public val dryrunName: Output<String>? = null,
    public val parameters: Output<CreateOrUpdateDryrunParametersArgs>? = null,
    public val resourceUri: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.servicelinker.LinkerDryrunArgs> {
    override fun toJava(): com.pulumi.azurenative.servicelinker.LinkerDryrunArgs =
        com.pulumi.azurenative.servicelinker.LinkerDryrunArgs.builder()
            .dryrunName(dryrunName?.applyValue({ args0 -> args0 }))
            .parameters(parameters?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceUri(resourceUri?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LinkerDryrunArgs].
 */
@PulumiTagMarker
public class LinkerDryrunArgsBuilder internal constructor() {
    private var dryrunName: Output<String>? = null

    private var parameters: Output<CreateOrUpdateDryrunParametersArgs>? = null

    private var resourceUri: Output<String>? = null

    /**
     * @param value The name of dryrun.
     */
    @JvmName("ftetkfwoqrnbuhys")
    public suspend fun dryrunName(`value`: Output<String>) {
        this.dryrunName = value
    }

    /**
     * @param value The parameters of the dryrun
     */
    @JvmName("remaqwuvcepiduad")
    public suspend fun parameters(`value`: Output<CreateOrUpdateDryrunParametersArgs>) {
        this.parameters = value
    }

    /**
     * @param value The fully qualified Azure Resource manager identifier of the resource to be connected.
     */
    @JvmName("wrsxussslrdidhpm")
    public suspend fun resourceUri(`value`: Output<String>) {
        this.resourceUri = value
    }

    /**
     * @param value The name of dryrun.
     */
    @JvmName("kqkqkgrfticynpen")
    public suspend fun dryrunName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dryrunName = mapped
    }

    /**
     * @param value The parameters of the dryrun
     */
    @JvmName("bidysbsymsoipcbx")
    public suspend fun parameters(`value`: CreateOrUpdateDryrunParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument The parameters of the dryrun
     */
    @JvmName("spoqbtaiqwcsfrlj")
    public suspend fun parameters(argument: suspend CreateOrUpdateDryrunParametersArgsBuilder.() -> Unit) {
        val toBeMapped = CreateOrUpdateDryrunParametersArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param value The fully qualified Azure Resource manager identifier of the resource to be connected.
     */
    @JvmName("dvhioohffslfcbdq")
    public suspend fun resourceUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceUri = mapped
    }

    internal fun build(): LinkerDryrunArgs = LinkerDryrunArgs(
        dryrunName = dryrunName,
        parameters = parameters,
        resourceUri = resourceUri,
    )
}
