@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicelinker.kotlin

import com.pulumi.azurenative.servicelinker.ServicelinkerFunctions.getConnectorDryrunPlain
import com.pulumi.azurenative.servicelinker.ServicelinkerFunctions.getConnectorPlain
import com.pulumi.azurenative.servicelinker.ServicelinkerFunctions.getLinkerDryrunPlain
import com.pulumi.azurenative.servicelinker.ServicelinkerFunctions.getLinkerPlain
import com.pulumi.azurenative.servicelinker.ServicelinkerFunctions.listLinkerConfigurationsPlain
import com.pulumi.azurenative.servicelinker.kotlin.inputs.GetConnectorDryrunPlainArgs
import com.pulumi.azurenative.servicelinker.kotlin.inputs.GetConnectorDryrunPlainArgsBuilder
import com.pulumi.azurenative.servicelinker.kotlin.inputs.GetConnectorPlainArgs
import com.pulumi.azurenative.servicelinker.kotlin.inputs.GetConnectorPlainArgsBuilder
import com.pulumi.azurenative.servicelinker.kotlin.inputs.GetLinkerDryrunPlainArgs
import com.pulumi.azurenative.servicelinker.kotlin.inputs.GetLinkerDryrunPlainArgsBuilder
import com.pulumi.azurenative.servicelinker.kotlin.inputs.GetLinkerPlainArgs
import com.pulumi.azurenative.servicelinker.kotlin.inputs.GetLinkerPlainArgsBuilder
import com.pulumi.azurenative.servicelinker.kotlin.inputs.ListLinkerConfigurationsPlainArgs
import com.pulumi.azurenative.servicelinker.kotlin.inputs.ListLinkerConfigurationsPlainArgsBuilder
import com.pulumi.azurenative.servicelinker.kotlin.outputs.GetConnectorDryrunResult
import com.pulumi.azurenative.servicelinker.kotlin.outputs.GetConnectorResult
import com.pulumi.azurenative.servicelinker.kotlin.outputs.GetLinkerDryrunResult
import com.pulumi.azurenative.servicelinker.kotlin.outputs.GetLinkerResult
import com.pulumi.azurenative.servicelinker.kotlin.outputs.ListLinkerConfigurationsResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.servicelinker.kotlin.outputs.GetConnectorDryrunResult.Companion.toKotlin as getConnectorDryrunResultToKotlin
import com.pulumi.azurenative.servicelinker.kotlin.outputs.GetConnectorResult.Companion.toKotlin as getConnectorResultToKotlin
import com.pulumi.azurenative.servicelinker.kotlin.outputs.GetLinkerDryrunResult.Companion.toKotlin as getLinkerDryrunResultToKotlin
import com.pulumi.azurenative.servicelinker.kotlin.outputs.GetLinkerResult.Companion.toKotlin as getLinkerResultToKotlin
import com.pulumi.azurenative.servicelinker.kotlin.outputs.ListLinkerConfigurationsResult.Companion.toKotlin as listLinkerConfigurationsResultToKotlin

public object ServicelinkerFunctions {
    /**
     * Returns Connector resource for a given name.
     * Azure REST API version: 2022-11-01-preview.
     * Other available API versions: 2023-04-01-preview, 2024-04-01.
     * @param argument null
     * @return Linker of source and target resource
     */
    public suspend fun getConnector(argument: GetConnectorPlainArgs): GetConnectorResult =
        getConnectorResultToKotlin(getConnectorPlain(argument.toJava()).await())

    /**
     * @see [getConnector].
     * @param connectorName The name of resource.
     * @param location The name of Azure region.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param subscriptionId The ID of the target subscription.
     * @return Linker of source and target resource
     */
    public suspend fun getConnector(
        connectorName: String,
        location: String,
        resourceGroupName: String,
        subscriptionId: String? = null,
    ): GetConnectorResult {
        val argument = GetConnectorPlainArgs(
            connectorName = connectorName,
            location = location,
            resourceGroupName = resourceGroupName,
            subscriptionId = subscriptionId,
        )
        return getConnectorResultToKotlin(getConnectorPlain(argument.toJava()).await())
    }

    /**
     * @see [getConnector].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;servicelinker&#46;kotlin&#46;inputs&#46;GetConnectorPlainArgs].
     * @return Linker of source and target resource
     */
    public suspend fun getConnector(argument: suspend GetConnectorPlainArgsBuilder.() -> Unit): GetConnectorResult {
        val builder = GetConnectorPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getConnectorResultToKotlin(getConnectorPlain(builtArgument.toJava()).await())
    }

    /**
     * get a dryrun job
     * Azure REST API version: 2022-11-01-preview.
     * Other available API versions: 2023-04-01-preview, 2024-04-01.
     * @param argument null
     * @return a dryrun job resource
     */
    public suspend fun getConnectorDryrun(argument: GetConnectorDryrunPlainArgs): GetConnectorDryrunResult =
        getConnectorDryrunResultToKotlin(getConnectorDryrunPlain(argument.toJava()).await())

    /**
     * @see [getConnectorDryrun].
     * @param dryrunName The name of dryrun.
     * @param location The name of Azure region.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param subscriptionId The ID of the target subscription.
     * @return a dryrun job resource
     */
    public suspend fun getConnectorDryrun(
        dryrunName: String,
        location: String,
        resourceGroupName: String,
        subscriptionId: String? = null,
    ): GetConnectorDryrunResult {
        val argument = GetConnectorDryrunPlainArgs(
            dryrunName = dryrunName,
            location = location,
            resourceGroupName = resourceGroupName,
            subscriptionId = subscriptionId,
        )
        return getConnectorDryrunResultToKotlin(getConnectorDryrunPlain(argument.toJava()).await())
    }

    /**
     * @see [getConnectorDryrun].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;servicelinker&#46;kotlin&#46;inputs&#46;GetConnectorDryrunPlainArgs].
     * @return a dryrun job resource
     */
    public suspend fun getConnectorDryrun(argument: suspend GetConnectorDryrunPlainArgsBuilder.() -> Unit): GetConnectorDryrunResult {
        val builder = GetConnectorDryrunPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getConnectorDryrunResultToKotlin(getConnectorDryrunPlain(builtArgument.toJava()).await())
    }

    /**
     * Returns Linker resource for a given name.
     * Azure REST API version: 2022-11-01-preview.
     * Other available API versions: 2021-11-01-preview, 2023-04-01-preview, 2024-04-01.
     * @param argument null
     * @return Linker of source and target resource
     */
    public suspend fun getLinker(argument: GetLinkerPlainArgs): GetLinkerResult =
        getLinkerResultToKotlin(getLinkerPlain(argument.toJava()).await())

    /**
     * @see [getLinker].
     * @param linkerName The name Linker resource.
     * @param resourceUri The fully qualified Azure Resource manager identifier of the resource to be connected.
     * @return Linker of source and target resource
     */
    public suspend fun getLinker(linkerName: String, resourceUri: String): GetLinkerResult {
        val argument = GetLinkerPlainArgs(
            linkerName = linkerName,
            resourceUri = resourceUri,
        )
        return getLinkerResultToKotlin(getLinkerPlain(argument.toJava()).await())
    }

    /**
     * @see [getLinker].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;servicelinker&#46;kotlin&#46;inputs&#46;GetLinkerPlainArgs].
     * @return Linker of source and target resource
     */
    public suspend fun getLinker(argument: suspend GetLinkerPlainArgsBuilder.() -> Unit): GetLinkerResult {
        val builder = GetLinkerPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLinkerResultToKotlin(getLinkerPlain(builtArgument.toJava()).await())
    }

    /**
     * get a dryrun job
     * Azure REST API version: 2022-11-01-preview.
     * Other available API versions: 2023-04-01-preview, 2024-04-01.
     * @param argument null
     * @return a dryrun job resource
     */
    public suspend fun getLinkerDryrun(argument: GetLinkerDryrunPlainArgs): GetLinkerDryrunResult =
        getLinkerDryrunResultToKotlin(getLinkerDryrunPlain(argument.toJava()).await())

    /**
     * @see [getLinkerDryrun].
     * @param dryrunName The name of dryrun.
     * @param resourceUri The fully qualified Azure Resource manager identifier of the resource to be connected.
     * @return a dryrun job resource
     */
    public suspend fun getLinkerDryrun(dryrunName: String, resourceUri: String): GetLinkerDryrunResult {
        val argument = GetLinkerDryrunPlainArgs(
            dryrunName = dryrunName,
            resourceUri = resourceUri,
        )
        return getLinkerDryrunResultToKotlin(getLinkerDryrunPlain(argument.toJava()).await())
    }

    /**
     * @see [getLinkerDryrun].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;servicelinker&#46;kotlin&#46;inputs&#46;GetLinkerDryrunPlainArgs].
     * @return a dryrun job resource
     */
    public suspend fun getLinkerDryrun(argument: suspend GetLinkerDryrunPlainArgsBuilder.() -> Unit): GetLinkerDryrunResult {
        val builder = GetLinkerDryrunPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLinkerDryrunResultToKotlin(getLinkerDryrunPlain(builtArgument.toJava()).await())
    }

    /**
     * list source configurations for a Linker.
     * Azure REST API version: 2022-11-01-preview.
     * Other available API versions: 2021-11-01-preview, 2023-04-01-preview, 2024-04-01.
     * @param argument null
     * @return Configurations for source resource, include appSettings, connectionString and serviceBindings
     */
    public suspend fun listLinkerConfigurations(argument: ListLinkerConfigurationsPlainArgs): ListLinkerConfigurationsResult =
        listLinkerConfigurationsResultToKotlin(listLinkerConfigurationsPlain(argument.toJava()).await())

    /**
     * @see [listLinkerConfigurations].
     * @param linkerName The name Linker resource.
     * @param resourceUri The fully qualified Azure Resource manager identifier of the resource to be connected.
     * @return Configurations for source resource, include appSettings, connectionString and serviceBindings
     */
    public suspend fun listLinkerConfigurations(linkerName: String, resourceUri: String): ListLinkerConfigurationsResult {
        val argument = ListLinkerConfigurationsPlainArgs(
            linkerName = linkerName,
            resourceUri = resourceUri,
        )
        return listLinkerConfigurationsResultToKotlin(listLinkerConfigurationsPlain(argument.toJava()).await())
    }

    /**
     * @see [listLinkerConfigurations].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;servicelinker&#46;kotlin&#46;inputs&#46;ListLinkerConfigurationsPlainArgs].
     * @return Configurations for source resource, include appSettings, connectionString and serviceBindings
     */
    public suspend fun listLinkerConfigurations(argument: suspend ListLinkerConfigurationsPlainArgsBuilder.() -> Unit): ListLinkerConfigurationsResult {
        val builder = ListLinkerConfigurationsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listLinkerConfigurationsResultToKotlin(listLinkerConfigurationsPlain(builtArgument.toJava()).await())
    }
}
