@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicelinker.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Optional. Indicates public network solution. If enable, enable public network access of target service with best try. Default is enable. If optOut, opt out public network access configuration.
 */
public enum class ActionType(
    public val javaValue: com.pulumi.azurenative.servicelinker.enums.ActionType,
) : ConvertibleToJava<com.pulumi.azurenative.servicelinker.enums.ActionType> {
    Enable(com.pulumi.azurenative.servicelinker.enums.ActionType.Enable),
    OptOut(com.pulumi.azurenative.servicelinker.enums.ActionType.OptOut),
    ;

    override fun toJava(): com.pulumi.azurenative.servicelinker.enums.ActionType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicelinker.enums.ActionType): ActionType = ActionType.values().first { it.javaValue == javaType }
    }
}
