@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicelinker.kotlin.inputs

import com.pulumi.azurenative.servicelinker.inputs.AzureResourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The azure resource info when target service type is AzureResource
 * @property id The Id of azure resource.
 * @property resourceProperties The azure resource connection related properties.
 * @property type The target service type.
 * Expected value is 'AzureResource'.
 */
public data class AzureResourceArgs(
    public val id: Output<String>? = null,
    public val resourceProperties: Output<AzureKeyVaultPropertiesArgs>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.servicelinker.inputs.AzureResourceArgs> {
    override fun toJava(): com.pulumi.azurenative.servicelinker.inputs.AzureResourceArgs =
        com.pulumi.azurenative.servicelinker.inputs.AzureResourceArgs.builder()
            .id(id?.applyValue({ args0 -> args0 }))
            .resourceProperties(
                resourceProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureResourceArgs].
 */
@PulumiTagMarker
public class AzureResourceArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var resourceProperties: Output<AzureKeyVaultPropertiesArgs>? = null

    private var type: Output<String>? = null

    /**
     * @param value The Id of azure resource.
     */
    @JvmName("qryqjtqgtgddbftf")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The azure resource connection related properties.
     */
    @JvmName("yncsdwayslpmcufr")
    public suspend fun resourceProperties(`value`: Output<AzureKeyVaultPropertiesArgs>) {
        this.resourceProperties = value
    }

    /**
     * @param value The target service type.
     * Expected value is 'AzureResource'.
     */
    @JvmName("tmcqsyqcfhoqfffs")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The Id of azure resource.
     */
    @JvmName("qnsxlrwmiuqfylrj")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The azure resource connection related properties.
     */
    @JvmName("qmqioayrpnbjxthb")
    public suspend fun resourceProperties(`value`: AzureKeyVaultPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceProperties = mapped
    }

    /**
     * @param argument The azure resource connection related properties.
     */
    @JvmName("fcwkgnllxnhhpwpc")
    public suspend fun resourceProperties(argument: suspend AzureKeyVaultPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = AzureKeyVaultPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.resourceProperties = mapped
    }

    /**
     * @param value The target service type.
     * Expected value is 'AzureResource'.
     */
    @JvmName("djbkcbpvmomeqdux")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): AzureResourceArgs = AzureResourceArgs(
        id = id,
        resourceProperties = resourceProperties,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
