@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicelinker.kotlin.inputs

import com.pulumi.azurenative.servicelinker.inputs.KeyVaultSecretReferenceSecretInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The secret info when type is keyVaultSecretReference. It's for scenario that user provides a secret stored in user's keyvault and source is Azure Kubernetes. The key Vault's resource id is linked to secretStore.keyVaultId.
 * @property name Name of the Key Vault secret.
 * @property secretType The secret type.
 * Expected value is 'keyVaultSecretReference'.
 * @property version Version of the Key Vault secret.
 */
public data class KeyVaultSecretReferenceSecretInfoArgs(
    public val name: Output<String>? = null,
    public val secretType: Output<String>,
    public val version: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.servicelinker.inputs.KeyVaultSecretReferenceSecretInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.servicelinker.inputs.KeyVaultSecretReferenceSecretInfoArgs =
        com.pulumi.azurenative.servicelinker.inputs.KeyVaultSecretReferenceSecretInfoArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .secretType(secretType.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KeyVaultSecretReferenceSecretInfoArgs].
 */
@PulumiTagMarker
public class KeyVaultSecretReferenceSecretInfoArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var secretType: Output<String>? = null

    private var version: Output<String>? = null

    /**
     * @param value Name of the Key Vault secret.
     */
    @JvmName("rwratrrunxrjyuma")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The secret type.
     * Expected value is 'keyVaultSecretReference'.
     */
    @JvmName("qaemufybsecaqhlx")
    public suspend fun secretType(`value`: Output<String>) {
        this.secretType = value
    }

    /**
     * @param value Version of the Key Vault secret.
     */
    @JvmName("gthqvtyoddmyrpnc")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value Name of the Key Vault secret.
     */
    @JvmName("hhqisrvvdydyydcq")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The secret type.
     * Expected value is 'keyVaultSecretReference'.
     */
    @JvmName("wvxogbnuuodurqgf")
    public suspend fun secretType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.secretType = mapped
    }

    /**
     * @param value Version of the Key Vault secret.
     */
    @JvmName("xwlwndudkqbpwapw")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): KeyVaultSecretReferenceSecretInfoArgs =
        KeyVaultSecretReferenceSecretInfoArgs(
            name = name,
            secretType = secretType ?: throw PulumiNullFieldException("secretType"),
            version = version,
        )
}
