@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicelinker.kotlin.inputs

import com.pulumi.azurenative.servicelinker.inputs.PublicNetworkSolutionArgs.builder
import com.pulumi.azurenative.servicelinker.kotlin.enums.ActionType
import com.pulumi.azurenative.servicelinker.kotlin.enums.DeleteOrUpdateBehavior
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Indicates public network solution, include firewall rules
 * @property action Optional. Indicates public network solution. If enable, enable public network access of target service with best try. Default is enable. If optOut, opt out public network access configuration.
 * @property deleteOrUpdateBehavior Indicates whether to clean up previous operation(such as firewall rules) when Linker is updating or deleting
 * @property firewallRules Describe firewall rules of target service to make sure source application could connect to the target.
 */
public data class PublicNetworkSolutionArgs(
    public val action: Output<Either<String, ActionType>>? = null,
    public val deleteOrUpdateBehavior: Output<Either<String, DeleteOrUpdateBehavior>>? = null,
    public val firewallRules: Output<FirewallRulesArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.servicelinker.inputs.PublicNetworkSolutionArgs> {
    override fun toJava(): com.pulumi.azurenative.servicelinker.inputs.PublicNetworkSolutionArgs =
        com.pulumi.azurenative.servicelinker.inputs.PublicNetworkSolutionArgs.builder()
            .action(
                action?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .deleteOrUpdateBehavior(
                deleteOrUpdateBehavior?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .firewallRules(firewallRules?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [PublicNetworkSolutionArgs].
 */
@PulumiTagMarker
public class PublicNetworkSolutionArgsBuilder internal constructor() {
    private var action: Output<Either<String, ActionType>>? = null

    private var deleteOrUpdateBehavior: Output<Either<String, DeleteOrUpdateBehavior>>? = null

    private var firewallRules: Output<FirewallRulesArgs>? = null

    /**
     * @param value Optional. Indicates public network solution. If enable, enable public network access of target service with best try. Default is enable. If optOut, opt out public network access configuration.
     */
    @JvmName("wbnnhhyanypmsciq")
    public suspend fun action(`value`: Output<Either<String, ActionType>>) {
        this.action = value
    }

    /**
     * @param value Indicates whether to clean up previous operation(such as firewall rules) when Linker is updating or deleting
     */
    @JvmName("qmfnuuwxqlyoblyi")
    public suspend fun deleteOrUpdateBehavior(`value`: Output<Either<String, DeleteOrUpdateBehavior>>) {
        this.deleteOrUpdateBehavior = value
    }

    /**
     * @param value Describe firewall rules of target service to make sure source application could connect to the target.
     */
    @JvmName("thgfbptspdehlgpd")
    public suspend fun firewallRules(`value`: Output<FirewallRulesArgs>) {
        this.firewallRules = value
    }

    /**
     * @param value Optional. Indicates public network solution. If enable, enable public network access of target service with best try. Default is enable. If optOut, opt out public network access configuration.
     */
    @JvmName("apmiurllylplajcg")
    public suspend fun action(`value`: Either<String, ActionType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value Optional. Indicates public network solution. If enable, enable public network access of target service with best try. Default is enable. If optOut, opt out public network access configuration.
     */
    @JvmName("okdbjvpmttjmnslr")
    public fun action(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ActionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value Optional. Indicates public network solution. If enable, enable public network access of target service with best try. Default is enable. If optOut, opt out public network access configuration.
     */
    @JvmName("tssfyndxgrhmvfmk")
    public fun action(`value`: ActionType) {
        val toBeMapped = Either.ofRight<String, ActionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value Indicates whether to clean up previous operation(such as firewall rules) when Linker is updating or deleting
     */
    @JvmName("sxpogfusehpdpmyr")
    public suspend fun deleteOrUpdateBehavior(`value`: Either<String, DeleteOrUpdateBehavior>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteOrUpdateBehavior = mapped
    }

    /**
     * @param value Indicates whether to clean up previous operation(such as firewall rules) when Linker is updating or deleting
     */
    @JvmName("vbcorshoptbxvdrr")
    public fun deleteOrUpdateBehavior(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DeleteOrUpdateBehavior>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deleteOrUpdateBehavior = mapped
    }

    /**
     * @param value Indicates whether to clean up previous operation(such as firewall rules) when Linker is updating or deleting
     */
    @JvmName("qutjkcginwjnmjxk")
    public fun deleteOrUpdateBehavior(`value`: DeleteOrUpdateBehavior) {
        val toBeMapped = Either.ofRight<String, DeleteOrUpdateBehavior>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deleteOrUpdateBehavior = mapped
    }

    /**
     * @param value Describe firewall rules of target service to make sure source application could connect to the target.
     */
    @JvmName("sugebpeprgxysohd")
    public suspend fun firewallRules(`value`: FirewallRulesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.firewallRules = mapped
    }

    /**
     * @param argument Describe firewall rules of target service to make sure source application could connect to the target.
     */
    @JvmName("twaqoxenrfwxbmgq")
    public suspend fun firewallRules(argument: suspend FirewallRulesArgsBuilder.() -> Unit) {
        val toBeMapped = FirewallRulesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.firewallRules = mapped
    }

    internal fun build(): PublicNetworkSolutionArgs = PublicNetworkSolutionArgs(
        action = action,
        deleteOrUpdateBehavior = deleteOrUpdateBehavior,
        firewallRules = firewallRules,
    )
}
