@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicelinker.kotlin.inputs

import com.pulumi.azurenative.servicelinker.inputs.SecretAuthInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The authentication info when authType is secret
 * @property authType The authentication type.
 * Expected value is 'secret'.
 * @property name Username or account name for secret auth.
 * @property secretInfo Password or key vault secret for secret auth.
 */
public data class SecretAuthInfoArgs(
    public val authType: Output<String>,
    public val name: Output<String>? = null,
    public val secretInfo: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.servicelinker.inputs.SecretAuthInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.servicelinker.inputs.SecretAuthInfoArgs =
        com.pulumi.azurenative.servicelinker.inputs.SecretAuthInfoArgs.builder()
            .authType(authType.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .secretInfo(secretInfo?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SecretAuthInfoArgs].
 */
@PulumiTagMarker
public class SecretAuthInfoArgsBuilder internal constructor() {
    private var authType: Output<String>? = null

    private var name: Output<String>? = null

    private var secretInfo: Output<Any>? = null

    /**
     * @param value The authentication type.
     * Expected value is 'secret'.
     */
    @JvmName("cpeptdaqgurvgjiv")
    public suspend fun authType(`value`: Output<String>) {
        this.authType = value
    }

    /**
     * @param value Username or account name for secret auth.
     */
    @JvmName("lpwrpfbtbbgullfo")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Password or key vault secret for secret auth.
     */
    @JvmName("jdhqistbbrbtxacg")
    public suspend fun secretInfo(`value`: Output<Any>) {
        this.secretInfo = value
    }

    /**
     * @param value The authentication type.
     * Expected value is 'secret'.
     */
    @JvmName("uwcpnftxppwdtgni")
    public suspend fun authType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authType = mapped
    }

    /**
     * @param value Username or account name for secret auth.
     */
    @JvmName("grdujgehyyooonjj")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Password or key vault secret for secret auth.
     */
    @JvmName("iuccxfmeuajpifyj")
    public suspend fun secretInfo(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretInfo = mapped
    }

    internal fun build(): SecretAuthInfoArgs = SecretAuthInfoArgs(
        authType = authType ?: throw PulumiNullFieldException("authType"),
        name = name,
        secretInfo = secretInfo,
    )
}
