@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicelinker.kotlin.inputs

import com.pulumi.azurenative.servicelinker.inputs.ServicePrincipalCertificateAuthInfoArgs.builder
import com.pulumi.azurenative.servicelinker.kotlin.enums.DeleteOrUpdateBehavior
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The authentication info when authType is servicePrincipal certificate
 * @property authType The authentication type.
 * Expected value is 'servicePrincipalCertificate'.
 * @property certificate ServicePrincipal certificate for servicePrincipal auth.
 * @property clientId Application clientId for servicePrincipal auth.
 * @property deleteOrUpdateBehavior Indicates whether to clean up previous operation when Linker is updating or deleting
 * @property principalId Principal Id for servicePrincipal auth.
 * @property roles Optional, this value specifies the Azure roles to be assigned. Automatically
 */
public data class ServicePrincipalCertificateAuthInfoArgs(
    public val authType: Output<String>,
    public val certificate: Output<String>,
    public val clientId: Output<String>,
    public val deleteOrUpdateBehavior: Output<Either<String, DeleteOrUpdateBehavior>>? = null,
    public val principalId: Output<String>,
    public val roles: Output<List<String>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.servicelinker.inputs.ServicePrincipalCertificateAuthInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.servicelinker.inputs.ServicePrincipalCertificateAuthInfoArgs =
        com.pulumi.azurenative.servicelinker.inputs.ServicePrincipalCertificateAuthInfoArgs.builder()
            .authType(authType.applyValue({ args0 -> args0 }))
            .certificate(certificate.applyValue({ args0 -> args0 }))
            .clientId(clientId.applyValue({ args0 -> args0 }))
            .deleteOrUpdateBehavior(
                deleteOrUpdateBehavior?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .principalId(principalId.applyValue({ args0 -> args0 }))
            .roles(roles?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ServicePrincipalCertificateAuthInfoArgs].
 */
@PulumiTagMarker
public class ServicePrincipalCertificateAuthInfoArgsBuilder internal constructor() {
    private var authType: Output<String>? = null

    private var certificate: Output<String>? = null

    private var clientId: Output<String>? = null

    private var deleteOrUpdateBehavior: Output<Either<String, DeleteOrUpdateBehavior>>? = null

    private var principalId: Output<String>? = null

    private var roles: Output<List<String>>? = null

    /**
     * @param value The authentication type.
     * Expected value is 'servicePrincipalCertificate'.
     */
    @JvmName("psanybjutcsvafre")
    public suspend fun authType(`value`: Output<String>) {
        this.authType = value
    }

    /**
     * @param value ServicePrincipal certificate for servicePrincipal auth.
     */
    @JvmName("fiptvhbohyejkyoi")
    public suspend fun certificate(`value`: Output<String>) {
        this.certificate = value
    }

    /**
     * @param value Application clientId for servicePrincipal auth.
     */
    @JvmName("jgtpjlhmfcucefhh")
    public suspend fun clientId(`value`: Output<String>) {
        this.clientId = value
    }

    /**
     * @param value Indicates whether to clean up previous operation when Linker is updating or deleting
     */
    @JvmName("ifjqyallkgyvjxye")
    public suspend fun deleteOrUpdateBehavior(`value`: Output<Either<String, DeleteOrUpdateBehavior>>) {
        this.deleteOrUpdateBehavior = value
    }

    /**
     * @param value Principal Id for servicePrincipal auth.
     */
    @JvmName("jsevwhhcbirtwdrh")
    public suspend fun principalId(`value`: Output<String>) {
        this.principalId = value
    }

    /**
     * @param value Optional, this value specifies the Azure roles to be assigned. Automatically
     */
    @JvmName("gjitqkqisdwenboy")
    public suspend fun roles(`value`: Output<List<String>>) {
        this.roles = value
    }

    @JvmName("hmxcbtawcrkceokg")
    public suspend fun roles(vararg values: Output<String>) {
        this.roles = Output.all(values.asList())
    }

    /**
     * @param values Optional, this value specifies the Azure roles to be assigned. Automatically
     */
    @JvmName("dcwnjrfgircvaqny")
    public suspend fun roles(values: List<Output<String>>) {
        this.roles = Output.all(values)
    }

    /**
     * @param value The authentication type.
     * Expected value is 'servicePrincipalCertificate'.
     */
    @JvmName("otsjlxvttsyusjtx")
    public suspend fun authType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authType = mapped
    }

    /**
     * @param value ServicePrincipal certificate for servicePrincipal auth.
     */
    @JvmName("vssvwduvhbdrjwxa")
    public suspend fun certificate(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.certificate = mapped
    }

    /**
     * @param value Application clientId for servicePrincipal auth.
     */
    @JvmName("fjkfvmgsbahhpveh")
    public suspend fun clientId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientId = mapped
    }

    /**
     * @param value Indicates whether to clean up previous operation when Linker is updating or deleting
     */
    @JvmName("bbidxixaipoyqnhp")
    public suspend fun deleteOrUpdateBehavior(`value`: Either<String, DeleteOrUpdateBehavior>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteOrUpdateBehavior = mapped
    }

    /**
     * @param value Indicates whether to clean up previous operation when Linker is updating or deleting
     */
    @JvmName("moearopspymmqjkm")
    public fun deleteOrUpdateBehavior(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DeleteOrUpdateBehavior>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deleteOrUpdateBehavior = mapped
    }

    /**
     * @param value Indicates whether to clean up previous operation when Linker is updating or deleting
     */
    @JvmName("orfkqavgjgggstsu")
    public fun deleteOrUpdateBehavior(`value`: DeleteOrUpdateBehavior) {
        val toBeMapped = Either.ofRight<String, DeleteOrUpdateBehavior>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deleteOrUpdateBehavior = mapped
    }

    /**
     * @param value Principal Id for servicePrincipal auth.
     */
    @JvmName("cgkgsjuanxiaeeeb")
    public suspend fun principalId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.principalId = mapped
    }

    /**
     * @param value Optional, this value specifies the Azure roles to be assigned. Automatically
     */
    @JvmName("gwyyyysgvxjpehrf")
    public suspend fun roles(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roles = mapped
    }

    /**
     * @param values Optional, this value specifies the Azure roles to be assigned. Automatically
     */
    @JvmName("efkuvsvhodmqvkaf")
    public suspend fun roles(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roles = mapped
    }

    internal fun build(): ServicePrincipalCertificateAuthInfoArgs =
        ServicePrincipalCertificateAuthInfoArgs(
            authType = authType ?: throw PulumiNullFieldException("authType"),
            certificate = certificate ?: throw PulumiNullFieldException("certificate"),
            clientId = clientId ?: throw PulumiNullFieldException("clientId"),
            deleteOrUpdateBehavior = deleteOrUpdateBehavior,
            principalId = principalId ?: throw PulumiNullFieldException("principalId"),
            roles = roles,
        )
}
