@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicelinker.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * The dryrun parameters for creation or update a linker
 * @property actionName The name of action for you dryrun job.
 * Expected value is 'createOrUpdate'.
 * @property authInfo The authentication type.
 * @property clientType The application client type
 * @property configurationInfo The connection information consumed by applications, including secrets, connection strings.
 * @property provisioningState The provisioning state.
 * @property publicNetworkSolution The network solution.
 * @property scope connection scope in source service.
 * @property secretStore An option to store secret value in secure place
 * @property targetService The target service properties
 * @property vNetSolution The VNet solution.
 */
public data class CreateOrUpdateDryrunParametersResponse(
    public val actionName: String,
    public val authInfo: Any? = null,
    public val clientType: String? = null,
    public val configurationInfo: ConfigurationInfoResponse? = null,
    public val provisioningState: String,
    public val publicNetworkSolution: PublicNetworkSolutionResponse? = null,
    public val scope: String? = null,
    public val secretStore: SecretStoreResponse? = null,
    public val targetService: Any? = null,
    public val vNetSolution: VNetSolutionResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicelinker.outputs.CreateOrUpdateDryrunParametersResponse): CreateOrUpdateDryrunParametersResponse = CreateOrUpdateDryrunParametersResponse(
            actionName = javaType.actionName(),
            authInfo = javaType.authInfo().map({ args0 -> args0 }).orElse(null),
            clientType = javaType.clientType().map({ args0 -> args0 }).orElse(null),
            configurationInfo = javaType.configurationInfo().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.servicelinker.kotlin.outputs.ConfigurationInfoResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
            publicNetworkSolution = javaType.publicNetworkSolution().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.servicelinker.kotlin.outputs.PublicNetworkSolutionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            scope = javaType.scope().map({ args0 -> args0 }).orElse(null),
            secretStore = javaType.secretStore().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.servicelinker.kotlin.outputs.SecretStoreResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            targetService = javaType.targetService().map({ args0 -> args0 }).orElse(null),
            vNetSolution = javaType.vNetSolution().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.servicelinker.kotlin.outputs.VNetSolutionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
