@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicelinker.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The dapr component metadata.
 * @property name Metadata property name.
 * @property secretRef The secret name where dapr could get value
 * @property value Metadata property value.
 */
public data class DaprMetadataResponse(
    public val name: String? = null,
    public val secretRef: String? = null,
    public val `value`: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicelinker.outputs.DaprMetadataResponse): DaprMetadataResponse = DaprMetadataResponse(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            secretRef = javaType.secretRef().map({ args0 -> args0 }).orElse(null),
            `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
        )
    }
}
