@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicelinker.kotlin.outputs

import com.pulumi.core.Either
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * a dryrun job resource
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property operationPreviews the preview of the operations for creation
 * @property parameters The parameters of the dryrun
 * @property prerequisiteResults the result of the dryrun
 * @property provisioningState The provisioning state.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetConnectorDryrunResult(
    public val id: String,
    public val name: String,
    public val operationPreviews: List<DryrunOperationPreviewResponse>,
    public val parameters: CreateOrUpdateDryrunParametersResponse? = null,
    public val prerequisiteResults: List<Either<BasicErrorDryrunPrerequisiteResultResponse, PermissionsMissingDryrunPrerequisiteResultResponse>>,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicelinker.outputs.GetConnectorDryrunResult): GetConnectorDryrunResult = GetConnectorDryrunResult(
            id = javaType.id(),
            name = javaType.name(),
            operationPreviews = javaType.operationPreviews().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.servicelinker.kotlin.outputs.DryrunOperationPreviewResponse.Companion.toKotlin(args0)
                })
            }),
            parameters = javaType.parameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.servicelinker.kotlin.outputs.CreateOrUpdateDryrunParametersResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            prerequisiteResults = javaType.prerequisiteResults().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.servicelinker.kotlin.outputs.BasicErrorDryrunPrerequisiteResultResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.servicelinker.kotlin.outputs.PermissionsMissingDryrunPrerequisiteResultResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.servicelinker.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
