@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicelinker.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * Linker of source and target resource
 * @property authInfo The authentication type.
 * @property clientType The application client type
 * @property configurationInfo The connection information consumed by applications, including secrets, connection strings.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property provisioningState The provisioning state.
 * @property publicNetworkSolution The network solution.
 * @property scope connection scope in source service.
 * @property secretStore An option to store secret value in secure place
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property targetService The target service properties
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property vNetSolution The VNet solution.
 */
public data class GetLinkerResult(
    public val authInfo: Any? = null,
    public val clientType: String? = null,
    public val configurationInfo: ConfigurationInfoResponse? = null,
    public val id: String,
    public val name: String,
    public val provisioningState: String,
    public val publicNetworkSolution: PublicNetworkSolutionResponse? = null,
    public val scope: String? = null,
    public val secretStore: SecretStoreResponse? = null,
    public val systemData: SystemDataResponse,
    public val targetService: Any? = null,
    public val type: String,
    public val vNetSolution: VNetSolutionResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicelinker.outputs.GetLinkerResult): GetLinkerResult = GetLinkerResult(
            authInfo = javaType.authInfo().map({ args0 -> args0 }).orElse(null),
            clientType = javaType.clientType().map({ args0 -> args0 }).orElse(null),
            configurationInfo = javaType.configurationInfo().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.servicelinker.kotlin.outputs.ConfigurationInfoResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            publicNetworkSolution = javaType.publicNetworkSolution().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.servicelinker.kotlin.outputs.PublicNetworkSolutionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            scope = javaType.scope().map({ args0 -> args0 }).orElse(null),
            secretStore = javaType.secretStore().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.servicelinker.kotlin.outputs.SecretStoreResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.servicelinker.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            targetService = javaType.targetService().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            vNetSolution = javaType.vNetSolution().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.servicelinker.kotlin.outputs.VNetSolutionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
