@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicelinker.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The secret info when type is keyVaultSecretReference. It's for scenario that user provides a secret stored in user's keyvault and source is Azure Kubernetes. The key Vault's resource id is linked to secretStore.keyVaultId.
 * @property name Name of the Key Vault secret.
 * @property secretType The secret type.
 * Expected value is 'keyVaultSecretReference'.
 * @property version Version of the Key Vault secret.
 */
public data class KeyVaultSecretReferenceSecretInfoResponse(
    public val name: String? = null,
    public val secretType: String,
    public val version: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicelinker.outputs.KeyVaultSecretReferenceSecretInfoResponse): KeyVaultSecretReferenceSecretInfoResponse = KeyVaultSecretReferenceSecretInfoResponse(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            secretType = javaType.secretType(),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
