@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicelinker.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The represent of missing permissions
 * @property permissions The permission list
 * @property recommendedRole The recommended role to resolve permissions missing
 * @property scope The permission scope
 * @property type The type of dryrun result.
 * Expected value is 'permissionsMissing'.
 */
public data class PermissionsMissingDryrunPrerequisiteResultResponse(
    public val permissions: List<String>? = null,
    public val recommendedRole: String? = null,
    public val scope: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicelinker.outputs.PermissionsMissingDryrunPrerequisiteResultResponse): PermissionsMissingDryrunPrerequisiteResultResponse =
            PermissionsMissingDryrunPrerequisiteResultResponse(
                permissions = javaType.permissions().map({ args0 -> args0 }),
                recommendedRole = javaType.recommendedRole().map({ args0 -> args0 }).orElse(null),
                scope = javaType.scope().map({ args0 -> args0 }).orElse(null),
                type = javaType.type(),
            )
    }
}
