@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicelinker.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Indicates public network solution, include firewall rules
 * @property action Optional. Indicates public network solution. If enable, enable public network access of target service with best try. Default is enable. If optOut, opt out public network access configuration.
 * @property deleteOrUpdateBehavior Indicates whether to clean up previous operation(such as firewall rules) when Linker is updating or deleting
 * @property firewallRules Describe firewall rules of target service to make sure source application could connect to the target.
 */
public data class PublicNetworkSolutionResponse(
    public val action: String? = null,
    public val deleteOrUpdateBehavior: String? = null,
    public val firewallRules: FirewallRulesResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicelinker.outputs.PublicNetworkSolutionResponse): PublicNetworkSolutionResponse = PublicNetworkSolutionResponse(
            action = javaType.action().map({ args0 -> args0 }).orElse(null),
            deleteOrUpdateBehavior = javaType.deleteOrUpdateBehavior().map({ args0 -> args0 }).orElse(null),
            firewallRules = javaType.firewallRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.servicelinker.kotlin.outputs.FirewallRulesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
