@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicelinker.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * The authentication info when authType is secret
 * @property authType The authentication type.
 * Expected value is 'secret'.
 * @property name Username or account name for secret auth.
 * @property secretInfo Password or key vault secret for secret auth.
 */
public data class SecretAuthInfoResponse(
    public val authType: String,
    public val name: String? = null,
    public val secretInfo: Any? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicelinker.outputs.SecretAuthInfoResponse): SecretAuthInfoResponse = SecretAuthInfoResponse(
            authType = javaType.authType(),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            secretInfo = javaType.secretInfo().map({ args0 -> args0 }).orElse(null),
        )
    }
}
