@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicelinker.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The authentication info when authType is servicePrincipal certificate
 * @property authType The authentication type.
 * Expected value is 'servicePrincipalCertificate'.
 * @property certificate ServicePrincipal certificate for servicePrincipal auth.
 * @property clientId Application clientId for servicePrincipal auth.
 * @property deleteOrUpdateBehavior Indicates whether to clean up previous operation when Linker is updating or deleting
 * @property principalId Principal Id for servicePrincipal auth.
 * @property roles Optional, this value specifies the Azure roles to be assigned. Automatically
 */
public data class ServicePrincipalCertificateAuthInfoResponse(
    public val authType: String,
    public val certificate: String,
    public val clientId: String,
    public val deleteOrUpdateBehavior: String? = null,
    public val principalId: String,
    public val roles: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicelinker.outputs.ServicePrincipalCertificateAuthInfoResponse): ServicePrincipalCertificateAuthInfoResponse = ServicePrincipalCertificateAuthInfoResponse(
            authType = javaType.authType(),
            certificate = javaType.certificate(),
            clientId = javaType.clientId(),
            deleteOrUpdateBehavior = javaType.deleteOrUpdateBehavior().map({ args0 -> args0 }).orElse(null),
            principalId = javaType.principalId(),
            roles = javaType.roles().map({ args0 -> args0 }),
        )
    }
}
