@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicelinker.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The authentication info when authType is servicePrincipal secret
 * @property authType The authentication type.
 * Expected value is 'servicePrincipalSecret'.
 * @property clientId ServicePrincipal application clientId for servicePrincipal auth.
 * @property deleteOrUpdateBehavior Indicates whether to clean up previous operation when Linker is updating or deleting
 * @property principalId Principal Id for servicePrincipal auth.
 * @property roles Optional, this value specifies the Azure roles to be assigned. Automatically
 * @property secret Secret for servicePrincipal auth.
 * @property userName Username created in the database which is mapped to a user in AAD.
 */
public data class ServicePrincipalSecretAuthInfoResponse(
    public val authType: String,
    public val clientId: String,
    public val deleteOrUpdateBehavior: String? = null,
    public val principalId: String,
    public val roles: List<String>? = null,
    public val secret: String,
    public val userName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicelinker.outputs.ServicePrincipalSecretAuthInfoResponse): ServicePrincipalSecretAuthInfoResponse = ServicePrincipalSecretAuthInfoResponse(
            authType = javaType.authType(),
            clientId = javaType.clientId(),
            deleteOrUpdateBehavior = javaType.deleteOrUpdateBehavior().map({ args0 -> args0 }).orElse(null),
            principalId = javaType.principalId(),
            roles = javaType.roles().map({ args0 -> args0 }),
            secret = javaType.secret(),
            userName = javaType.userName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
