@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicenetworking.kotlin

import com.pulumi.azurenative.servicenetworking.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.servicenetworking.kotlin.outputs.WafPolicyResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.servicenetworking.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin
import com.pulumi.azurenative.servicenetworking.kotlin.outputs.WafPolicyResponse.Companion.toKotlin as wafPolicyResponseToKotlin

/**
 * Builder for [SecurityPoliciesInterface].
 */
@PulumiTagMarker
public class SecurityPoliciesInterfaceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SecurityPoliciesInterfaceArgs = SecurityPoliciesInterfaceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SecurityPoliciesInterfaceArgsBuilder.() -> Unit) {
        val builder = SecurityPoliciesInterfaceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SecurityPoliciesInterface {
        val builtJavaResource =
            com.pulumi.azurenative.servicenetworking.SecurityPoliciesInterface(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return SecurityPoliciesInterface(builtJavaResource)
    }
}

/**
 * SecurityPolicy Subresource of Traffic Controller.
 * Azure REST API version: 2024-05-01-preview.
 * ## Example Usage
 * ### Put SecurityPolicy
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var securityPoliciesInterface = new AzureNative.ServiceNetworking.SecurityPoliciesInterface("securityPoliciesInterface", new()
 *     {
 *         Location = "NorthCentralUS",
 *         ResourceGroupName = "rg1",
 *         SecurityPolicyName = "sp1",
 *         TrafficControllerName = "tc1",
 *         WafPolicy = new AzureNative.ServiceNetworking.Inputs.WafPolicyArgs
 *         {
 *             Id = "/subscriptions/subid/resourcegroups/rg1/providers/Microsoft.Networking/applicationGatewayWebApplicationFirewallPolicies/wp-0",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/servicenetworking/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicenetworking.NewSecurityPoliciesInterface(ctx, "securityPoliciesInterface", &servicenetworking.SecurityPoliciesInterfaceArgs{
 * 			Location:              pulumi.String("NorthCentralUS"),
 * 			ResourceGroupName:     pulumi.String("rg1"),
 * 			SecurityPolicyName:    pulumi.String("sp1"),
 * 			TrafficControllerName: pulumi.String("tc1"),
 * 			WafPolicy: &servicenetworking.WafPolicyArgs{
 * 				Id: pulumi.String("/subscriptions/subid/resourcegroups/rg1/providers/Microsoft.Networking/applicationGatewayWebApplicationFirewallPolicies/wp-0"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.servicenetworking.SecurityPoliciesInterface;
 * import com.pulumi.azurenative.servicenetworking.SecurityPoliciesInterfaceArgs;
 * import com.pulumi.azurenative.servicenetworking.inputs.WafPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var securityPoliciesInterface = new SecurityPoliciesInterface("securityPoliciesInterface", SecurityPoliciesInterfaceArgs.builder()
 *             .location("NorthCentralUS")
 *             .resourceGroupName("rg1")
 *             .securityPolicyName("sp1")
 *             .trafficControllerName("tc1")
 *             .wafPolicy(WafPolicyArgs.builder()
 *                 .id("/subscriptions/subid/resourcegroups/rg1/providers/Microsoft.Networking/applicationGatewayWebApplicationFirewallPolicies/wp-0")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:servicenetworking:SecurityPoliciesInterface waf-0 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceNetworking/trafficControllers/{trafficControllerName}/securityPolicy/{securityPolicyName}
 * ```
 */
public class SecurityPoliciesInterface internal constructor(
    override val javaResource: com.pulumi.azurenative.servicenetworking.SecurityPoliciesInterface,
) : KotlinCustomResource(javaResource, SecurityPoliciesInterfaceMapper) {
    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Type of the Traffic Controller Security Policy
     */
    public val policyType: Output<String>
        get() = javaResource.policyType().applyValue({ args0 -> args0 })

    /**
     * Provisioning State of Traffic Controller SecurityPolicy Resource
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Web Application Firewall Policy of the Traffic Controller Security Policy
     */
    public val wafPolicy: Output<WafPolicyResponse>?
        get() = javaResource.wafPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    wafPolicyResponseToKotlin(args0)
                })
            }).orElse(null)
        })
}

public object SecurityPoliciesInterfaceMapper : ResourceMapper<SecurityPoliciesInterface> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.servicenetworking.SecurityPoliciesInterface::class == javaResource::class

    override fun map(javaResource: Resource): SecurityPoliciesInterface =
        SecurityPoliciesInterface(
            javaResource as
                com.pulumi.azurenative.servicenetworking.SecurityPoliciesInterface,
        )
}

/**
 * @see [SecurityPoliciesInterface].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SecurityPoliciesInterface].
 */
public suspend fun securityPoliciesInterface(
    name: String,
    block: suspend SecurityPoliciesInterfaceResourceBuilder.() -> Unit,
): SecurityPoliciesInterface {
    val builder = SecurityPoliciesInterfaceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SecurityPoliciesInterface].
 * @param name The _unique_ name of the resulting resource.
 */
public fun securityPoliciesInterface(name: String): SecurityPoliciesInterface {
    val builder = SecurityPoliciesInterfaceResourceBuilder()
    builder.name(name)
    return builder.build()
}
