@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicenetworking.kotlin

import com.pulumi.azurenative.servicenetworking.SecurityPoliciesInterfaceArgs.builder
import com.pulumi.azurenative.servicenetworking.kotlin.inputs.WafPolicyArgs
import com.pulumi.azurenative.servicenetworking.kotlin.inputs.WafPolicyArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * SecurityPolicy Subresource of Traffic Controller.
 * Azure REST API version: 2024-05-01-preview.
 * ## Example Usage
 * ### Put SecurityPolicy
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var securityPoliciesInterface = new AzureNative.ServiceNetworking.SecurityPoliciesInterface("securityPoliciesInterface", new()
 *     {
 *         Location = "NorthCentralUS",
 *         ResourceGroupName = "rg1",
 *         SecurityPolicyName = "sp1",
 *         TrafficControllerName = "tc1",
 *         WafPolicy = new AzureNative.ServiceNetworking.Inputs.WafPolicyArgs
 *         {
 *             Id = "/subscriptions/subid/resourcegroups/rg1/providers/Microsoft.Networking/applicationGatewayWebApplicationFirewallPolicies/wp-0",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/servicenetworking/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicenetworking.NewSecurityPoliciesInterface(ctx, "securityPoliciesInterface", &servicenetworking.SecurityPoliciesInterfaceArgs{
 * 			Location:              pulumi.String("NorthCentralUS"),
 * 			ResourceGroupName:     pulumi.String("rg1"),
 * 			SecurityPolicyName:    pulumi.String("sp1"),
 * 			TrafficControllerName: pulumi.String("tc1"),
 * 			WafPolicy: &servicenetworking.WafPolicyArgs{
 * 				Id: pulumi.String("/subscriptions/subid/resourcegroups/rg1/providers/Microsoft.Networking/applicationGatewayWebApplicationFirewallPolicies/wp-0"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.servicenetworking.SecurityPoliciesInterface;
 * import com.pulumi.azurenative.servicenetworking.SecurityPoliciesInterfaceArgs;
 * import com.pulumi.azurenative.servicenetworking.inputs.WafPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var securityPoliciesInterface = new SecurityPoliciesInterface("securityPoliciesInterface", SecurityPoliciesInterfaceArgs.builder()
 *             .location("NorthCentralUS")
 *             .resourceGroupName("rg1")
 *             .securityPolicyName("sp1")
 *             .trafficControllerName("tc1")
 *             .wafPolicy(WafPolicyArgs.builder()
 *                 .id("/subscriptions/subid/resourcegroups/rg1/providers/Microsoft.Networking/applicationGatewayWebApplicationFirewallPolicies/wp-0")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:servicenetworking:SecurityPoliciesInterface waf-0 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceNetworking/trafficControllers/{trafficControllerName}/securityPolicy/{securityPolicyName}
 * ```
 * @property location The geo-location where the resource lives
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property securityPolicyName SecurityPolicy
 * @property tags Resource tags.
 * @property trafficControllerName traffic controller name for path
 * @property wafPolicy Web Application Firewall Policy of the Traffic Controller Security Policy
 */
public data class SecurityPoliciesInterfaceArgs(
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val securityPolicyName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val trafficControllerName: Output<String>? = null,
    public val wafPolicy: Output<WafPolicyArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.servicenetworking.SecurityPoliciesInterfaceArgs> {
    override fun toJava(): com.pulumi.azurenative.servicenetworking.SecurityPoliciesInterfaceArgs =
        com.pulumi.azurenative.servicenetworking.SecurityPoliciesInterfaceArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .securityPolicyName(securityPolicyName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .trafficControllerName(trafficControllerName?.applyValue({ args0 -> args0 }))
            .wafPolicy(wafPolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [SecurityPoliciesInterfaceArgs].
 */
@PulumiTagMarker
public class SecurityPoliciesInterfaceArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var securityPolicyName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var trafficControllerName: Output<String>? = null

    private var wafPolicy: Output<WafPolicyArgs>? = null

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("qfnkauyhjvplnmld")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("pxpwqjknblxddqle")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value SecurityPolicy
     */
    @JvmName("jxncbhuwydvitvpp")
    public suspend fun securityPolicyName(`value`: Output<String>) {
        this.securityPolicyName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("sqcpsxucbubsxahh")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value traffic controller name for path
     */
    @JvmName("ymmkadkpoyjgxeum")
    public suspend fun trafficControllerName(`value`: Output<String>) {
        this.trafficControllerName = value
    }

    /**
     * @param value Web Application Firewall Policy of the Traffic Controller Security Policy
     */
    @JvmName("didrgovwmtgfgftf")
    public suspend fun wafPolicy(`value`: Output<WafPolicyArgs>) {
        this.wafPolicy = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("inehmlgqgrgcqwdp")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ihrmtilpvrhmqfdo")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value SecurityPolicy
     */
    @JvmName("esmacqcbudxfgjjs")
    public suspend fun securityPolicyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityPolicyName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("ktywxvasdxjlilyp")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("fecquaypinuwlbxe")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value traffic controller name for path
     */
    @JvmName("qtnfujtjhneoujtr")
    public suspend fun trafficControllerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trafficControllerName = mapped
    }

    /**
     * @param value Web Application Firewall Policy of the Traffic Controller Security Policy
     */
    @JvmName("mgtyfkmbfhoglbub")
    public suspend fun wafPolicy(`value`: WafPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.wafPolicy = mapped
    }

    /**
     * @param argument Web Application Firewall Policy of the Traffic Controller Security Policy
     */
    @JvmName("hkauobytxpmrykim")
    public suspend fun wafPolicy(argument: suspend WafPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = WafPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.wafPolicy = mapped
    }

    internal fun build(): SecurityPoliciesInterfaceArgs = SecurityPoliciesInterfaceArgs(
        location = location,
        resourceGroupName = resourceGroupName,
        securityPolicyName = securityPolicyName,
        tags = tags,
        trafficControllerName = trafficControllerName,
        wafPolicy = wafPolicy,
    )
}
