@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicenetworking.kotlin

import com.pulumi.azurenative.servicenetworking.TrafficControllerInterfaceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Concrete tracked resource types can be created by aliasing this type using a specific property type.
 * Azure REST API version: 2023-05-01-preview. Prior API version in Azure Native 1.x: 2022-10-01-preview.
 * Other available API versions: 2022-10-01-preview, 2023-11-01, 2024-05-01-preview.
 * ## Example Usage
 * ### Put Traffic Controller
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var trafficControllerInterface = new AzureNative.ServiceNetworking.TrafficControllerInterface("trafficControllerInterface", new()
 *     {
 *         Location = "NorthCentralUS",
 *         ResourceGroupName = "rg1",
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *         },
 *         TrafficControllerName = "tc1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/servicenetworking/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicenetworking.NewTrafficControllerInterface(ctx, "trafficControllerInterface", &servicenetworking.TrafficControllerInterfaceArgs{
 * 			Location:          pulumi.String("NorthCentralUS"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 			TrafficControllerName: pulumi.String("tc1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.servicenetworking.TrafficControllerInterface;
 * import com.pulumi.azurenative.servicenetworking.TrafficControllerInterfaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var trafficControllerInterface = new TrafficControllerInterface("trafficControllerInterface", TrafficControllerInterfaceArgs.builder()
 *             .location("NorthCentralUS")
 *             .resourceGroupName("rg1")
 *             .tags(Map.of("key1", "value1"))
 *             .trafficControllerName("tc1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:servicenetworking:TrafficControllerInterface tc1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceNetworking/trafficControllers/{trafficControllerName}
 * ```
 * @property location The geo-location where the resource lives
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 * @property trafficControllerName traffic controller name for path
 */
public data class TrafficControllerInterfaceArgs(
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val trafficControllerName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.servicenetworking.TrafficControllerInterfaceArgs> {
    override fun toJava(): com.pulumi.azurenative.servicenetworking.TrafficControllerInterfaceArgs =
        com.pulumi.azurenative.servicenetworking.TrafficControllerInterfaceArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .trafficControllerName(trafficControllerName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TrafficControllerInterfaceArgs].
 */
@PulumiTagMarker
public class TrafficControllerInterfaceArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var trafficControllerName: Output<String>? = null

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("agcekgykvmxkepja")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("onxwtkcrfamsmbdx")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("xptktovxxilpipog")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value traffic controller name for path
     */
    @JvmName("djpscfthcogutqnn")
    public suspend fun trafficControllerName(`value`: Output<String>) {
        this.trafficControllerName = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("jtyioagaiyhfjjja")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("quwxbixhfgwkuuav")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("votttkbpiaxqbwev")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("mirxludvabyagbtv")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value traffic controller name for path
     */
    @JvmName("odlplvxlxkkfncur")
    public suspend fun trafficControllerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trafficControllerName = mapped
    }

    internal fun build(): TrafficControllerInterfaceArgs = TrafficControllerInterfaceArgs(
        location = location,
        resourceGroupName = resourceGroupName,
        tags = tags,
        trafficControllerName = trafficControllerName,
    )
}
