@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicenetworking.kotlin.inputs

import com.pulumi.azurenative.servicenetworking.inputs.GetAssociationsInterfacePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property associationName Name of Association
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property trafficControllerName traffic controller name for path
 */
public data class GetAssociationsInterfacePlainArgs(
    public val associationName: String,
    public val resourceGroupName: String,
    public val trafficControllerName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.servicenetworking.inputs.GetAssociationsInterfacePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.servicenetworking.inputs.GetAssociationsInterfacePlainArgs =
        com.pulumi.azurenative.servicenetworking.inputs.GetAssociationsInterfacePlainArgs.builder()
            .associationName(associationName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .trafficControllerName(trafficControllerName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAssociationsInterfacePlainArgs].
 */
@PulumiTagMarker
public class GetAssociationsInterfacePlainArgsBuilder internal constructor() {
    private var associationName: String? = null

    private var resourceGroupName: String? = null

    private var trafficControllerName: String? = null

    /**
     * @param value Name of Association
     */
    @JvmName("nwtwfbbipdcnfnrt")
    public suspend fun associationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.associationName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("rgadxkxgcwxedryt")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value traffic controller name for path
     */
    @JvmName("ktucivcuiqvplvjg")
    public suspend fun trafficControllerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.trafficControllerName = mapped
    }

    internal fun build(): GetAssociationsInterfacePlainArgs = GetAssociationsInterfacePlainArgs(
        associationName = associationName ?: throw PulumiNullFieldException("associationName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        trafficControllerName = trafficControllerName ?: throw
            PulumiNullFieldException("trafficControllerName"),
    )
}
