@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicenetworking.kotlin.inputs

import com.pulumi.azurenative.servicenetworking.inputs.GetSecurityPoliciesInterfacePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property securityPolicyName SecurityPolicy
 * @property trafficControllerName traffic controller name for path
 */
public data class GetSecurityPoliciesInterfacePlainArgs(
    public val resourceGroupName: String,
    public val securityPolicyName: String,
    public val trafficControllerName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.servicenetworking.inputs.GetSecurityPoliciesInterfacePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.servicenetworking.inputs.GetSecurityPoliciesInterfacePlainArgs =
        com.pulumi.azurenative.servicenetworking.inputs.GetSecurityPoliciesInterfacePlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .securityPolicyName(securityPolicyName.let({ args0 -> args0 }))
            .trafficControllerName(trafficControllerName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSecurityPoliciesInterfacePlainArgs].
 */
@PulumiTagMarker
public class GetSecurityPoliciesInterfacePlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var securityPolicyName: String? = null

    private var trafficControllerName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("xpiiintcfslobkac")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value SecurityPolicy
     */
    @JvmName("lskbtkjtiyujhuue")
    public suspend fun securityPolicyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.securityPolicyName = mapped
    }

    /**
     * @param value traffic controller name for path
     */
    @JvmName("oacohxbfvbhyvmaw")
    public suspend fun trafficControllerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.trafficControllerName = mapped
    }

    internal fun build(): GetSecurityPoliciesInterfacePlainArgs =
        GetSecurityPoliciesInterfacePlainArgs(
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            securityPolicyName = securityPolicyName ?: throw PulumiNullFieldException("securityPolicyName"),
            trafficControllerName = trafficControllerName ?: throw
                PulumiNullFieldException("trafficControllerName"),
        )
}
