@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicenetworking.kotlin.inputs

import com.pulumi.azurenative.servicenetworking.inputs.WafPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Web Application Firewall Policy
 * @property id Resource ID of the WAF
 */
public data class WafPolicyArgs(
    public val id: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.servicenetworking.inputs.WafPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.servicenetworking.inputs.WafPolicyArgs =
        com.pulumi.azurenative.servicenetworking.inputs.WafPolicyArgs.builder()
            .id(id.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WafPolicyArgs].
 */
@PulumiTagMarker
public class WafPolicyArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    /**
     * @param value Resource ID of the WAF
     */
    @JvmName("xlrqxwxltytsqqkg")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Resource ID of the WAF
     */
    @JvmName("xdusaakdkfpinedg")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): WafPolicyArgs = WafPolicyArgs(
        id = id ?: throw PulumiNullFieldException("id"),
    )
}
