@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.signalrservice.kotlin.inputs

import com.pulumi.azurenative.signalrservice.inputs.GetSignalRCustomCertificatePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property certificateName Custom certificate name
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property resourceName The name of the resource.
 */
public data class GetSignalRCustomCertificatePlainArgs(
    public val certificateName: String,
    public val resourceGroupName: String,
    public val resourceName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.signalrservice.inputs.GetSignalRCustomCertificatePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.signalrservice.inputs.GetSignalRCustomCertificatePlainArgs =
        com.pulumi.azurenative.signalrservice.inputs.GetSignalRCustomCertificatePlainArgs.builder()
            .certificateName(certificateName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .resourceName(resourceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSignalRCustomCertificatePlainArgs].
 */
@PulumiTagMarker
public class GetSignalRCustomCertificatePlainArgsBuilder internal constructor() {
    private var certificateName: String? = null

    private var resourceGroupName: String? = null

    private var resourceName: String? = null

    /**
     * @param value Custom certificate name
     */
    @JvmName("jdpbsqhpacaaghxm")
    public suspend fun certificateName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.certificateName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("erccibbhfvelppxm")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the resource.
     */
    @JvmName("jnujulonhxmcqnrq")
    public suspend fun resourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceName = mapped
    }

    internal fun build(): GetSignalRCustomCertificatePlainArgs = GetSignalRCustomCertificatePlainArgs(
        certificateName = certificateName ?: throw PulumiNullFieldException("certificateName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        resourceName = resourceName ?: throw PulumiNullFieldException("resourceName"),
    )
}
