@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.signalrservice.kotlin.inputs

import com.pulumi.azurenative.signalrservice.inputs.GetSignalRSharedPrivateLinkResourcePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property resourceName The name of the resource.
 * @property sharedPrivateLinkResourceName The name of the shared private link resource
 */
public data class GetSignalRSharedPrivateLinkResourcePlainArgs(
    public val resourceGroupName: String,
    public val resourceName: String,
    public val sharedPrivateLinkResourceName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.signalrservice.inputs.GetSignalRSharedPrivateLinkResourcePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.signalrservice.inputs.GetSignalRSharedPrivateLinkResourcePlainArgs =
        com.pulumi.azurenative.signalrservice.inputs.GetSignalRSharedPrivateLinkResourcePlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .resourceName(resourceName.let({ args0 -> args0 }))
            .sharedPrivateLinkResourceName(sharedPrivateLinkResourceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSignalRSharedPrivateLinkResourcePlainArgs].
 */
@PulumiTagMarker
public class GetSignalRSharedPrivateLinkResourcePlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var resourceName: String? = null

    private var sharedPrivateLinkResourceName: String? = null

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("jlnyqggtfutymfjk")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the resource.
     */
    @JvmName("hxbqqjkmeleoaefc")
    public suspend fun resourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceName = mapped
    }

    /**
     * @param value The name of the shared private link resource
     */
    @JvmName("crlpqgmyjcgrygiy")
    public suspend fun sharedPrivateLinkResourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.sharedPrivateLinkResourceName = mapped
    }

    internal fun build(): GetSignalRSharedPrivateLinkResourcePlainArgs =
        GetSignalRSharedPrivateLinkResourcePlainArgs(
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            resourceName = resourceName ?: throw PulumiNullFieldException("resourceName"),
            sharedPrivateLinkResourceName = sharedPrivateLinkResourceName ?: throw
                PulumiNullFieldException("sharedPrivateLinkResourceName"),
        )
}
