@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.signalrservice.kotlin.inputs

import com.pulumi.azurenative.signalrservice.inputs.PrivateEndpointACLArgs.builder
import com.pulumi.azurenative.signalrservice.kotlin.enums.SignalRRequestType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * ACL for a private endpoint
 * @property allow Allowed request types. The value can be one or more of: ClientConnection, ServerConnection, RESTAPI.
 * @property deny Denied request types. The value can be one or more of: ClientConnection, ServerConnection, RESTAPI.
 * @property name Name of the private endpoint connection
 */
public data class PrivateEndpointACLArgs(
    public val allow: Output<List<Either<String, SignalRRequestType>>>? = null,
    public val deny: Output<List<Either<String, SignalRRequestType>>>? = null,
    public val name: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.signalrservice.inputs.PrivateEndpointACLArgs> {
    override fun toJava(): com.pulumi.azurenative.signalrservice.inputs.PrivateEndpointACLArgs =
        com.pulumi.azurenative.signalrservice.inputs.PrivateEndpointACLArgs.builder()
            .allow(
                allow?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 -> args0 }, { args0 ->
                            args0.let({ args0 -> args0.toJava() })
                        })
                    })
                }),
            )
            .deny(
                deny?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 -> args0 }, { args0 ->
                            args0.let({ args0 -> args0.toJava() })
                        })
                    })
                }),
            )
            .name(name.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PrivateEndpointACLArgs].
 */
@PulumiTagMarker
public class PrivateEndpointACLArgsBuilder internal constructor() {
    private var allow: Output<List<Either<String, SignalRRequestType>>>? = null

    private var deny: Output<List<Either<String, SignalRRequestType>>>? = null

    private var name: Output<String>? = null

    /**
     * @param value Allowed request types. The value can be one or more of: ClientConnection, ServerConnection, RESTAPI.
     */
    @JvmName("appbsahjvloscsfl")
    public suspend fun allow(`value`: Output<List<Either<String, SignalRRequestType>>>) {
        this.allow = value
    }

    @JvmName("rursrkwtxvdxmfuk")
    public suspend fun allow(vararg values: Output<Either<String, SignalRRequestType>>) {
        this.allow = Output.all(values.asList())
    }

    /**
     * @param values Allowed request types. The value can be one or more of: ClientConnection, ServerConnection, RESTAPI.
     */
    @JvmName("qyfidqtkcvxfoqgs")
    public suspend fun allow(values: List<Output<Either<String, SignalRRequestType>>>) {
        this.allow = Output.all(values)
    }

    /**
     * @param value Denied request types. The value can be one or more of: ClientConnection, ServerConnection, RESTAPI.
     */
    @JvmName("inmrbrelnvcdhpuv")
    public suspend fun deny(`value`: Output<List<Either<String, SignalRRequestType>>>) {
        this.deny = value
    }

    @JvmName("fymajjhvyqqripqo")
    public suspend fun deny(vararg values: Output<Either<String, SignalRRequestType>>) {
        this.deny = Output.all(values.asList())
    }

    /**
     * @param values Denied request types. The value can be one or more of: ClientConnection, ServerConnection, RESTAPI.
     */
    @JvmName("juvroaanyvnjyqcf")
    public suspend fun deny(values: List<Output<Either<String, SignalRRequestType>>>) {
        this.deny = Output.all(values)
    }

    /**
     * @param value Name of the private endpoint connection
     */
    @JvmName("ulyyssxvangauqvw")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Allowed request types. The value can be one or more of: ClientConnection, ServerConnection, RESTAPI.
     */
    @JvmName("holxsbslwgxognex")
    public suspend fun allow(`value`: List<Either<String, SignalRRequestType>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allow = mapped
    }

    /**
     * @param values Allowed request types. The value can be one or more of: ClientConnection, ServerConnection, RESTAPI.
     */
    @JvmName("umxkfawkipuieatm")
    public suspend fun allow(vararg values: Either<String, SignalRRequestType>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allow = mapped
    }

    /**
     * @param value Denied request types. The value can be one or more of: ClientConnection, ServerConnection, RESTAPI.
     */
    @JvmName("rnrtwerqmtgxxjod")
    public suspend fun deny(`value`: List<Either<String, SignalRRequestType>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deny = mapped
    }

    /**
     * @param values Denied request types. The value can be one or more of: ClientConnection, ServerConnection, RESTAPI.
     */
    @JvmName("klumsmefvjtooymx")
    public suspend fun deny(vararg values: Either<String, SignalRRequestType>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deny = mapped
    }

    /**
     * @param value Name of the private endpoint connection
     */
    @JvmName("rppuvupokyxurwhu")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): PrivateEndpointACLArgs = PrivateEndpointACLArgs(
        allow = allow,
        deny = deny,
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
