@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.signalrservice.kotlin.inputs

import com.pulumi.azurenative.signalrservice.inputs.PrivateLinkServiceConnectionStateArgs.builder
import com.pulumi.azurenative.signalrservice.kotlin.enums.PrivateLinkServiceConnectionStatus
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Connection state of the private endpoint connection
 * @property actionsRequired A message indicating if changes on the service provider require any updates on the consumer.
 * @property description The reason for approval/rejection of the connection.
 * @property status Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
 */
public data class PrivateLinkServiceConnectionStateArgs(
    public val actionsRequired: Output<String>? = null,
    public val description: Output<String>? = null,
    public val status: Output<Either<String, PrivateLinkServiceConnectionStatus>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.signalrservice.inputs.PrivateLinkServiceConnectionStateArgs> {
    override fun toJava(): com.pulumi.azurenative.signalrservice.inputs.PrivateLinkServiceConnectionStateArgs =
        com.pulumi.azurenative.signalrservice.inputs.PrivateLinkServiceConnectionStateArgs.builder()
            .actionsRequired(actionsRequired?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .status(
                status?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [PrivateLinkServiceConnectionStateArgs].
 */
@PulumiTagMarker
public class PrivateLinkServiceConnectionStateArgsBuilder internal constructor() {
    private var actionsRequired: Output<String>? = null

    private var description: Output<String>? = null

    private var status: Output<Either<String, PrivateLinkServiceConnectionStatus>>? = null

    /**
     * @param value A message indicating if changes on the service provider require any updates on the consumer.
     */
    @JvmName("futygainaprlgyfu")
    public suspend fun actionsRequired(`value`: Output<String>) {
        this.actionsRequired = value
    }

    /**
     * @param value The reason for approval/rejection of the connection.
     */
    @JvmName("pqrcmxjvdndxhcfu")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
     */
    @JvmName("emmetowgqjflkmjd")
    public suspend fun status(`value`: Output<Either<String, PrivateLinkServiceConnectionStatus>>) {
        this.status = value
    }

    /**
     * @param value A message indicating if changes on the service provider require any updates on the consumer.
     */
    @JvmName("vnehlrrpgsfetudb")
    public suspend fun actionsRequired(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.actionsRequired = mapped
    }

    /**
     * @param value The reason for approval/rejection of the connection.
     */
    @JvmName("bbshowagqtympxdj")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
     */
    @JvmName("mtfahjfxkbtlqxvr")
    public suspend fun status(`value`: Either<String, PrivateLinkServiceConnectionStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
     */
    @JvmName("hcssimrtfoodqfhj")
    public fun status(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PrivateLinkServiceConnectionStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
     */
    @JvmName("mtlkomkygelcfsbu")
    public fun status(`value`: PrivateLinkServiceConnectionStatus) {
        val toBeMapped = Either.ofRight<String, PrivateLinkServiceConnectionStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): PrivateLinkServiceConnectionStateArgs =
        PrivateLinkServiceConnectionStateArgs(
            actionsRequired = actionsRequired,
            description = description,
            status = status,
        )
}
