@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.signalrservice.kotlin.inputs

import com.pulumi.azurenative.signalrservice.inputs.UpstreamAuthSettingsArgs.builder
import com.pulumi.azurenative.signalrservice.kotlin.enums.UpstreamAuthType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Upstream auth settings. If not set, no auth is used for upstream messages.
 * @property managedIdentity Managed identity settings for upstream.
 * @property type Upstream auth type enum.
 */
public data class UpstreamAuthSettingsArgs(
    public val managedIdentity: Output<ManagedIdentitySettingsArgs>? = null,
    public val type: Output<Either<String, UpstreamAuthType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.signalrservice.inputs.UpstreamAuthSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.signalrservice.inputs.UpstreamAuthSettingsArgs =
        com.pulumi.azurenative.signalrservice.inputs.UpstreamAuthSettingsArgs.builder()
            .managedIdentity(managedIdentity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [UpstreamAuthSettingsArgs].
 */
@PulumiTagMarker
public class UpstreamAuthSettingsArgsBuilder internal constructor() {
    private var managedIdentity: Output<ManagedIdentitySettingsArgs>? = null

    private var type: Output<Either<String, UpstreamAuthType>>? = null

    /**
     * @param value Managed identity settings for upstream.
     */
    @JvmName("hkrsfodmeljywatn")
    public suspend fun managedIdentity(`value`: Output<ManagedIdentitySettingsArgs>) {
        this.managedIdentity = value
    }

    /**
     * @param value Upstream auth type enum.
     */
    @JvmName("jaiqxuvtqnanhfud")
    public suspend fun type(`value`: Output<Either<String, UpstreamAuthType>>) {
        this.type = value
    }

    /**
     * @param value Managed identity settings for upstream.
     */
    @JvmName("hdhtymqomgomjkud")
    public suspend fun managedIdentity(`value`: ManagedIdentitySettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedIdentity = mapped
    }

    /**
     * @param argument Managed identity settings for upstream.
     */
    @JvmName("elvvqhmckwvkavxv")
    public suspend fun managedIdentity(argument: suspend ManagedIdentitySettingsArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedIdentitySettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.managedIdentity = mapped
    }

    /**
     * @param value Upstream auth type enum.
     */
    @JvmName("pkylfsfybyfynmmj")
    public suspend fun type(`value`: Either<String, UpstreamAuthType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Upstream auth type enum.
     */
    @JvmName("ihcmfgiqwnwuvhun")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, UpstreamAuthType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Upstream auth type enum.
     */
    @JvmName("ogqxnpphjuwdlcxn")
    public fun type(`value`: UpstreamAuthType) {
        val toBeMapped = Either.ofRight<String, UpstreamAuthType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): UpstreamAuthSettingsArgs = UpstreamAuthSettingsArgs(
        managedIdentity = managedIdentity,
        type = type,
    )
}
