@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.signalrservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A custom certificate.
 * @property id Fully qualified resource Id for the resource.
 * @property keyVaultBaseUri Base uri of the KeyVault that stores certificate.
 * @property keyVaultSecretName Certificate secret name.
 * @property keyVaultSecretVersion Certificate secret version.
 * @property name The name of the resource.
 * @property provisioningState Provisioning state of the resource.
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property type The type of the resource - e.g. "Microsoft.SignalRService/SignalR"
 */
public data class GetSignalRCustomCertificateResult(
    public val id: String,
    public val keyVaultBaseUri: String,
    public val keyVaultSecretName: String,
    public val keyVaultSecretVersion: String? = null,
    public val name: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.signalrservice.outputs.GetSignalRCustomCertificateResult): GetSignalRCustomCertificateResult = GetSignalRCustomCertificateResult(
            id = javaType.id(),
            keyVaultBaseUri = javaType.keyVaultBaseUri(),
            keyVaultSecretName = javaType.keyVaultSecretName(),
            keyVaultSecretVersion = javaType.keyVaultSecretVersion().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.signalrservice.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
