@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.signalrservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A custom domain
 * @property customCertificate Reference to a resource.
 * @property domainName The custom domain name.
 * @property id Fully qualified resource Id for the resource.
 * @property name The name of the resource.
 * @property provisioningState Provisioning state of the resource.
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property type The type of the resource - e.g. "Microsoft.SignalRService/SignalR"
 */
public data class GetSignalRCustomDomainResult(
    public val customCertificate: ResourceReferenceResponse,
    public val domainName: String,
    public val id: String,
    public val name: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.signalrservice.outputs.GetSignalRCustomDomainResult): GetSignalRCustomDomainResult = GetSignalRCustomDomainResult(
            customCertificate = javaType.customCertificate().let({ args0 ->
                com.pulumi.azurenative.signalrservice.kotlin.outputs.ResourceReferenceResponse.Companion.toKotlin(args0)
            }),
            domainName = javaType.domainName(),
            id = javaType.id(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.signalrservice.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
