@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.signalrservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Live trace configuration of a Microsoft.SignalRService resource.
 * @property categories Gets or sets the list of category configurations.
 * @property enabled Indicates whether or not enable live trace.
 * When it's set to true, live trace client can connect to the service.
 * Otherwise, live trace client can't connect to the service, so that you are unable to receive any log, no matter what you configure in "categories".
 * Available values: true, false.
 * Case insensitive.
 */
public data class LiveTraceConfigurationResponse(
    public val categories: List<LiveTraceCategoryResponse>? = null,
    public val enabled: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.signalrservice.outputs.LiveTraceConfigurationResponse): LiveTraceConfigurationResponse = LiveTraceConfigurationResponse(
            categories = javaType.categories().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.signalrservice.kotlin.outputs.LiveTraceCategoryResponse.Companion.toKotlin(args0)
                })
            }),
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
        )
    }
}
