@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.signalrservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Managed identity settings for upstream.
 * @property resource The Resource indicating the App ID URI of the target resource.
 * It also appears in the aud (audience) claim of the issued token.
 */
public data class ManagedIdentitySettingsResponse(
    public val resource: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.signalrservice.outputs.ManagedIdentitySettingsResponse): ManagedIdentitySettingsResponse = ManagedIdentitySettingsResponse(
            resource = javaType.resource().map({ args0 -> args0 }).orElse(null),
        )
    }
}
