@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.signalrservice.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 * TLS settings for the resource
 * @property clientCertEnabled Request client certificate during TLS handshake if enabled
 */
public data class SignalRTlsSettingsResponse(
    public val clientCertEnabled: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.signalrservice.outputs.SignalRTlsSettingsResponse): SignalRTlsSettingsResponse = SignalRTlsSettingsResponse(
            clientCertEnabled = javaType.clientCertEnabled().map({ args0 -> args0 }).orElse(null),
        )
    }
}
