@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.softwareplan.kotlin

import com.pulumi.azurenative.softwareplan.kotlin.outputs.SkuResponse
import com.pulumi.azurenative.softwareplan.kotlin.outputs.SkuResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [HybridUseBenefit].
 */
@PulumiTagMarker
public class HybridUseBenefitResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: HybridUseBenefitArgs = HybridUseBenefitArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend HybridUseBenefitArgsBuilder.() -> Unit) {
        val builder = HybridUseBenefitArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): HybridUseBenefit {
        val builtJavaResource =
            com.pulumi.azurenative.softwareplan.HybridUseBenefit(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return HybridUseBenefit(builtJavaResource)
    }
}

/**
 * Response on GET of a hybrid use benefit
 * Azure REST API version: 2019-12-01. Prior API version in Azure Native 1.x: 2019-06-01-preview.
 * ## Example Usage
 * ### HybridUseBenefit
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var hybridUseBenefit = new AzureNative.SoftwarePlan.HybridUseBenefit("hybridUseBenefit", new()
 *     {
 *         PlanId = "94f46eda-45f8-493a-8425-251921463a89",
 *         Scope = "subscriptions/{sub-id}/resourceGroups/{rg-name}/providers/Microsoft.Compute/HostGroups/{host-group-name}/hosts/{host-name}",
 *         Sku = new AzureNative.SoftwarePlan.Inputs.SkuArgs
 *         {
 *             Name = "SQL_Server_Perpetual",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/softwareplan/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := softwareplan.NewHybridUseBenefit(ctx, "hybridUseBenefit", &softwareplan.HybridUseBenefitArgs{
 * 			PlanId: pulumi.String("94f46eda-45f8-493a-8425-251921463a89"),
 * 			Scope:  pulumi.String("subscriptions/{sub-id}/resourceGroups/{rg-name}/providers/Microsoft.Compute/HostGroups/{host-group-name}/hosts/{host-name}"),
 * 			Sku: &softwareplan.SkuArgs{
 * 				Name: pulumi.String("SQL_Server_Perpetual"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.softwareplan.HybridUseBenefit;
 * import com.pulumi.azurenative.softwareplan.HybridUseBenefitArgs;
 * import com.pulumi.azurenative.softwareplan.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var hybridUseBenefit = new HybridUseBenefit("hybridUseBenefit", HybridUseBenefitArgs.builder()
 *             .planId("94f46eda-45f8-493a-8425-251921463a89")
 *             .scope("subscriptions/{sub-id}/resourceGroups/{rg-name}/providers/Microsoft.Compute/HostGroups/{host-group-name}/hosts/{host-name}")
 *             .sku(SkuArgs.builder()
 *                 .name("SQL_Server_Perpetual")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:softwareplan:HybridUseBenefit SQL_{hostGroupName}_{hostName} /{scope}/providers/Microsoft.SoftwarePlan/hybridUseBenefits/{planId}
 * ```
 */
public class HybridUseBenefit internal constructor(
    override val javaResource: com.pulumi.azurenative.softwareplan.HybridUseBenefit,
) : KotlinCustomResource(javaResource, HybridUseBenefitMapper) {
    /**
     * Created date
     */
    public val createdDate: Output<String>
        get() = javaResource.createdDate().applyValue({ args0 -> args0 })

    /**
     * Indicates the revision of the hybrid use benefit
     */
    public val etag: Output<Int>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * Last updated date
     */
    public val lastUpdatedDate: Output<String>
        get() = javaResource.lastUpdatedDate().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Provisioning state
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Hybrid use benefit SKU
     */
    public val sku: Output<SkuResponse>
        get() = javaResource.sku().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object HybridUseBenefitMapper : ResourceMapper<HybridUseBenefit> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.softwareplan.HybridUseBenefit::class == javaResource::class

    override fun map(javaResource: Resource): HybridUseBenefit = HybridUseBenefit(
        javaResource as
            com.pulumi.azurenative.softwareplan.HybridUseBenefit,
    )
}

/**
 * @see [HybridUseBenefit].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [HybridUseBenefit].
 */
public suspend fun hybridUseBenefit(
    name: String,
    block: suspend HybridUseBenefitResourceBuilder.() -> Unit,
): HybridUseBenefit {
    val builder = HybridUseBenefitResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [HybridUseBenefit].
 * @param name The _unique_ name of the resulting resource.
 */
public fun hybridUseBenefit(name: String): HybridUseBenefit {
    val builder = HybridUseBenefitResourceBuilder()
    builder.name(name)
    return builder.build()
}
