@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.softwareplan.kotlin

import com.pulumi.azurenative.softwareplan.SoftwareplanFunctions.getHybridUseBenefitPlain
import com.pulumi.azurenative.softwareplan.kotlin.inputs.GetHybridUseBenefitPlainArgs
import com.pulumi.azurenative.softwareplan.kotlin.inputs.GetHybridUseBenefitPlainArgsBuilder
import com.pulumi.azurenative.softwareplan.kotlin.outputs.GetHybridUseBenefitResult
import com.pulumi.azurenative.softwareplan.kotlin.outputs.GetHybridUseBenefitResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

public object SoftwareplanFunctions {
    /**
     * Gets a given plan ID
     * Azure REST API version: 2019-12-01.
     * @param argument null
     * @return Response on GET of a hybrid use benefit
     */
    public suspend fun getHybridUseBenefit(argument: GetHybridUseBenefitPlainArgs): GetHybridUseBenefitResult = toKotlin(getHybridUseBenefitPlain(argument.toJava()).await())

    /**
     * @see [getHybridUseBenefit].
     * @param planId This is a unique identifier for a plan. Should be a guid.
     * @param scope The scope at which the operation is performed. This is limited to Microsoft.Compute/virtualMachines and Microsoft.Compute/hostGroups/hosts for now
     * @return Response on GET of a hybrid use benefit
     */
    public suspend fun getHybridUseBenefit(planId: String, scope: String): GetHybridUseBenefitResult {
        val argument = GetHybridUseBenefitPlainArgs(
            planId = planId,
            scope = scope,
        )
        return toKotlin(getHybridUseBenefitPlain(argument.toJava()).await())
    }

    /**
     * @see [getHybridUseBenefit].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;softwareplan&#46;kotlin&#46;inputs&#46;GetHybridUseBenefitPlainArgs].
     * @return Response on GET of a hybrid use benefit
     */
    public suspend fun getHybridUseBenefit(argument: suspend GetHybridUseBenefitPlainArgsBuilder.() -> Unit): GetHybridUseBenefitResult {
        val builder = GetHybridUseBenefitPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getHybridUseBenefitPlain(builtArgument.toJava()).await())
    }
}
