@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.solutions.kotlin

import com.pulumi.azurenative.solutions.kotlin.outputs.ApplicationAuthorizationResponse
import com.pulumi.azurenative.solutions.kotlin.outputs.ApplicationDefinitionArtifactResponse
import com.pulumi.azurenative.solutions.kotlin.outputs.ApplicationDeploymentPolicyResponse
import com.pulumi.azurenative.solutions.kotlin.outputs.ApplicationManagementPolicyResponse
import com.pulumi.azurenative.solutions.kotlin.outputs.ApplicationNotificationPolicyResponse
import com.pulumi.azurenative.solutions.kotlin.outputs.ApplicationPackageLockingPolicyDefinitionResponse
import com.pulumi.azurenative.solutions.kotlin.outputs.ApplicationPolicyResponse
import com.pulumi.azurenative.solutions.kotlin.outputs.SkuResponse
import com.pulumi.azurenative.solutions.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.solutions.kotlin.outputs.ApplicationAuthorizationResponse.Companion.toKotlin as applicationAuthorizationResponseToKotlin
import com.pulumi.azurenative.solutions.kotlin.outputs.ApplicationDefinitionArtifactResponse.Companion.toKotlin as applicationDefinitionArtifactResponseToKotlin
import com.pulumi.azurenative.solutions.kotlin.outputs.ApplicationDeploymentPolicyResponse.Companion.toKotlin as applicationDeploymentPolicyResponseToKotlin
import com.pulumi.azurenative.solutions.kotlin.outputs.ApplicationManagementPolicyResponse.Companion.toKotlin as applicationManagementPolicyResponseToKotlin
import com.pulumi.azurenative.solutions.kotlin.outputs.ApplicationNotificationPolicyResponse.Companion.toKotlin as applicationNotificationPolicyResponseToKotlin
import com.pulumi.azurenative.solutions.kotlin.outputs.ApplicationPackageLockingPolicyDefinitionResponse.Companion.toKotlin as applicationPackageLockingPolicyDefinitionResponseToKotlin
import com.pulumi.azurenative.solutions.kotlin.outputs.ApplicationPolicyResponse.Companion.toKotlin as applicationPolicyResponseToKotlin
import com.pulumi.azurenative.solutions.kotlin.outputs.SkuResponse.Companion.toKotlin as skuResponseToKotlin
import com.pulumi.azurenative.solutions.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [ApplicationDefinition].
 */
@PulumiTagMarker
public class ApplicationDefinitionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ApplicationDefinitionArgs = ApplicationDefinitionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ApplicationDefinitionArgsBuilder.() -> Unit) {
        val builder = ApplicationDefinitionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ApplicationDefinition {
        val builtJavaResource =
            com.pulumi.azurenative.solutions.ApplicationDefinition(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ApplicationDefinition(builtJavaResource)
    }
}

/**
 * Information about managed application definition.
 * Azure REST API version: 2021-07-01. Prior API version in Azure Native 1.x: 2019-07-01.
 * Other available API versions: 2017-12-01, 2023-12-01-preview.
 * ## Example Usage
 * ### Create or update managed application definition
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var applicationDefinition = new AzureNative.Solutions.ApplicationDefinition("applicationDefinition", new()
 *     {
 *         ApplicationDefinitionName = "myManagedApplicationDef",
 *         Authorizations = new[]
 *         {
 *             new AzureNative.Solutions.Inputs.ApplicationAuthorizationArgs
 *             {
 *                 PrincipalId = "validprincipalguid",
 *                 RoleDefinitionId = "validroleguid",
 *             },
 *         },
 *         Description = "myManagedApplicationDef description",
 *         DisplayName = "myManagedApplicationDef",
 *         LockLevel = AzureNative.Solutions.ApplicationLockLevel.None,
 *         PackageFileUri = "https://path/to/packagezipfile",
 *         ResourceGroupName = "rg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/solutions/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := solutions.NewApplicationDefinition(ctx, "applicationDefinition", &solutions.ApplicationDefinitionArgs{
 * 			ApplicationDefinitionName: pulumi.String("myManagedApplicationDef"),
 * 			Authorizations: solutions.ApplicationAuthorizationArray{
 * 				&solutions.ApplicationAuthorizationArgs{
 * 					PrincipalId:      pulumi.String("validprincipalguid"),
 * 					RoleDefinitionId: pulumi.String("validroleguid"),
 * 				},
 * 			},
 * 			Description:       pulumi.String("myManagedApplicationDef description"),
 * 			DisplayName:       pulumi.String("myManagedApplicationDef"),
 * 			LockLevel:         solutions.ApplicationLockLevelNone,
 * 			PackageFileUri:    pulumi.String("https://path/to/packagezipfile"),
 * 			ResourceGroupName: pulumi.String("rg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.solutions.ApplicationDefinition;
 * import com.pulumi.azurenative.solutions.ApplicationDefinitionArgs;
 * import com.pulumi.azurenative.solutions.inputs.ApplicationAuthorizationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var applicationDefinition = new ApplicationDefinition("applicationDefinition", ApplicationDefinitionArgs.builder()
 *             .applicationDefinitionName("myManagedApplicationDef")
 *             .authorizations(ApplicationAuthorizationArgs.builder()
 *                 .principalId("validprincipalguid")
 *                 .roleDefinitionId("validroleguid")
 *                 .build())
 *             .description("myManagedApplicationDef description")
 *             .displayName("myManagedApplicationDef")
 *             .lockLevel("None")
 *             .packageFileUri("https://path/to/packagezipfile")
 *             .resourceGroupName("rg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:solutions:ApplicationDefinition myManagedApplicationDef /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Solutions/applicationDefinitions/{applicationDefinitionName}
 * ```
 */
public class ApplicationDefinition internal constructor(
    override val javaResource: com.pulumi.azurenative.solutions.ApplicationDefinition,
) : KotlinCustomResource(javaResource, ApplicationDefinitionMapper) {
    /**
     * The collection of managed application artifacts. The portal will use the files specified as artifacts to construct the user experience of creating a managed application from a managed application definition.
     */
    public val artifacts: Output<List<ApplicationDefinitionArtifactResponse>>?
        get() = javaResource.artifacts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        applicationDefinitionArtifactResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The managed application provider authorizations.
     */
    public val authorizations: Output<List<ApplicationAuthorizationResponse>>?
        get() = javaResource.authorizations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        applicationAuthorizationResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The createUiDefinition json for the backing template with Microsoft.Solutions/applications resource. It can be a JObject or well-formed JSON string.
     */
    public val createUiDefinition: Output<Any>?
        get() = javaResource.createUiDefinition().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The managed application deployment policy.
     */
    public val deploymentPolicy: Output<ApplicationDeploymentPolicyResponse>?
        get() = javaResource.deploymentPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> applicationDeploymentPolicyResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The managed application definition description.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The managed application definition display name.
     */
    public val displayName: Output<String>?
        get() = javaResource.displayName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A value indicating whether the package is enabled or not.
     */
    public val isEnabled: Output<Boolean>?
        get() = javaResource.isEnabled().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource location
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The managed application lock level.
     */
    public val lockLevel: Output<String>
        get() = javaResource.lockLevel().applyValue({ args0 -> args0 })

    /**
     * The managed application locking policy.
     */
    public val lockingPolicy: Output<ApplicationPackageLockingPolicyDefinitionResponse>?
        get() = javaResource.lockingPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    applicationPackageLockingPolicyDefinitionResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The inline main template json which has resources to be provisioned. It can be a JObject or well-formed JSON string.
     */
    public val mainTemplate: Output<Any>?
        get() = javaResource.mainTemplate().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ID of the resource that manages this resource.
     */
    public val managedBy: Output<String>?
        get() = javaResource.managedBy().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The managed application management policy that determines publisher's access to the managed resource group.
     */
    public val managementPolicy: Output<ApplicationManagementPolicyResponse>?
        get() = javaResource.managementPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> applicationManagementPolicyResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The managed application notification policy.
     */
    public val notificationPolicy: Output<ApplicationNotificationPolicyResponse>?
        get() = javaResource.notificationPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> applicationNotificationPolicyResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The managed application definition package file Uri. Use this element
     */
    public val packageFileUri: Output<String>?
        get() = javaResource.packageFileUri().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The managed application provider policies.
     */
    public val policies: Output<List<ApplicationPolicyResponse>>?
        get() = javaResource.policies().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> applicationPolicyResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The SKU of the resource.
     */
    public val sku: Output<SkuResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    skuResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The storage account id for bring your own storage scenario.
     */
    public val storageAccountId: Output<String>?
        get() = javaResource.storageAccountId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ApplicationDefinitionMapper : ResourceMapper<ApplicationDefinition> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.solutions.ApplicationDefinition::class == javaResource::class

    override fun map(javaResource: Resource): ApplicationDefinition =
        ApplicationDefinition(javaResource as com.pulumi.azurenative.solutions.ApplicationDefinition)
}

/**
 * @see [ApplicationDefinition].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ApplicationDefinition].
 */
public suspend fun applicationDefinition(
    name: String,
    block: suspend ApplicationDefinitionResourceBuilder.() -> Unit,
): ApplicationDefinition {
    val builder = ApplicationDefinitionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ApplicationDefinition].
 * @param name The _unique_ name of the resulting resource.
 */
public fun applicationDefinition(name: String): ApplicationDefinition {
    val builder = ApplicationDefinitionResourceBuilder()
    builder.name(name)
    return builder.build()
}
