@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.solutions.kotlin

import com.pulumi.azurenative.solutions.ApplicationDefinitionArgs.builder
import com.pulumi.azurenative.solutions.kotlin.enums.ApplicationLockLevel
import com.pulumi.azurenative.solutions.kotlin.inputs.ApplicationAuthorizationArgs
import com.pulumi.azurenative.solutions.kotlin.inputs.ApplicationAuthorizationArgsBuilder
import com.pulumi.azurenative.solutions.kotlin.inputs.ApplicationDefinitionArtifactArgs
import com.pulumi.azurenative.solutions.kotlin.inputs.ApplicationDefinitionArtifactArgsBuilder
import com.pulumi.azurenative.solutions.kotlin.inputs.ApplicationDeploymentPolicyArgs
import com.pulumi.azurenative.solutions.kotlin.inputs.ApplicationDeploymentPolicyArgsBuilder
import com.pulumi.azurenative.solutions.kotlin.inputs.ApplicationManagementPolicyArgs
import com.pulumi.azurenative.solutions.kotlin.inputs.ApplicationManagementPolicyArgsBuilder
import com.pulumi.azurenative.solutions.kotlin.inputs.ApplicationNotificationPolicyArgs
import com.pulumi.azurenative.solutions.kotlin.inputs.ApplicationNotificationPolicyArgsBuilder
import com.pulumi.azurenative.solutions.kotlin.inputs.ApplicationPackageLockingPolicyDefinitionArgs
import com.pulumi.azurenative.solutions.kotlin.inputs.ApplicationPackageLockingPolicyDefinitionArgsBuilder
import com.pulumi.azurenative.solutions.kotlin.inputs.ApplicationPolicyArgs
import com.pulumi.azurenative.solutions.kotlin.inputs.ApplicationPolicyArgsBuilder
import com.pulumi.azurenative.solutions.kotlin.inputs.SkuArgs
import com.pulumi.azurenative.solutions.kotlin.inputs.SkuArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Information about managed application definition.
 * Azure REST API version: 2021-07-01. Prior API version in Azure Native 1.x: 2019-07-01.
 * Other available API versions: 2017-12-01, 2023-12-01-preview.
 * ## Example Usage
 * ### Create or update managed application definition
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var applicationDefinition = new AzureNative.Solutions.ApplicationDefinition("applicationDefinition", new()
 *     {
 *         ApplicationDefinitionName = "myManagedApplicationDef",
 *         Authorizations = new[]
 *         {
 *             new AzureNative.Solutions.Inputs.ApplicationAuthorizationArgs
 *             {
 *                 PrincipalId = "validprincipalguid",
 *                 RoleDefinitionId = "validroleguid",
 *             },
 *         },
 *         Description = "myManagedApplicationDef description",
 *         DisplayName = "myManagedApplicationDef",
 *         LockLevel = AzureNative.Solutions.ApplicationLockLevel.None,
 *         PackageFileUri = "https://path/to/packagezipfile",
 *         ResourceGroupName = "rg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/solutions/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := solutions.NewApplicationDefinition(ctx, "applicationDefinition", &solutions.ApplicationDefinitionArgs{
 * 			ApplicationDefinitionName: pulumi.String("myManagedApplicationDef"),
 * 			Authorizations: solutions.ApplicationAuthorizationArray{
 * 				&solutions.ApplicationAuthorizationArgs{
 * 					PrincipalId:      pulumi.String("validprincipalguid"),
 * 					RoleDefinitionId: pulumi.String("validroleguid"),
 * 				},
 * 			},
 * 			Description:       pulumi.String("myManagedApplicationDef description"),
 * 			DisplayName:       pulumi.String("myManagedApplicationDef"),
 * 			LockLevel:         solutions.ApplicationLockLevelNone,
 * 			PackageFileUri:    pulumi.String("https://path/to/packagezipfile"),
 * 			ResourceGroupName: pulumi.String("rg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.solutions.ApplicationDefinition;
 * import com.pulumi.azurenative.solutions.ApplicationDefinitionArgs;
 * import com.pulumi.azurenative.solutions.inputs.ApplicationAuthorizationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var applicationDefinition = new ApplicationDefinition("applicationDefinition", ApplicationDefinitionArgs.builder()
 *             .applicationDefinitionName("myManagedApplicationDef")
 *             .authorizations(ApplicationAuthorizationArgs.builder()
 *                 .principalId("validprincipalguid")
 *                 .roleDefinitionId("validroleguid")
 *                 .build())
 *             .description("myManagedApplicationDef description")
 *             .displayName("myManagedApplicationDef")
 *             .lockLevel("None")
 *             .packageFileUri("https://path/to/packagezipfile")
 *             .resourceGroupName("rg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:solutions:ApplicationDefinition myManagedApplicationDef /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Solutions/applicationDefinitions/{applicationDefinitionName}
 * ```
 * @property applicationDefinitionName The name of the managed application definition.
 * @property artifacts The collection of managed application artifacts. The portal will use the files specified as artifacts to construct the user experience of creating a managed application from a managed application definition.
 * @property authorizations The managed application provider authorizations.
 * @property createUiDefinition The createUiDefinition json for the backing template with Microsoft.Solutions/applications resource. It can be a JObject or well-formed JSON string.
 * @property deploymentPolicy The managed application deployment policy.
 * @property description The managed application definition description.
 * @property displayName The managed application definition display name.
 * @property isEnabled A value indicating whether the package is enabled or not.
 * @property location Resource location
 * @property lockLevel The managed application lock level.
 * @property lockingPolicy The managed application locking policy.
 * @property mainTemplate The inline main template json which has resources to be provisioned. It can be a JObject or well-formed JSON string.
 * @property managedBy ID of the resource that manages this resource.
 * @property managementPolicy The managed application management policy that determines publisher's access to the managed resource group.
 * @property notificationPolicy The managed application notification policy.
 * @property packageFileUri The managed application definition package file Uri. Use this element
 * @property policies The managed application provider policies.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sku The SKU of the resource.
 * @property storageAccountId The storage account id for bring your own storage scenario.
 * @property tags Resource tags
 */
public data class ApplicationDefinitionArgs(
    public val applicationDefinitionName: Output<String>? = null,
    public val artifacts: Output<List<ApplicationDefinitionArtifactArgs>>? = null,
    public val authorizations: Output<List<ApplicationAuthorizationArgs>>? = null,
    public val createUiDefinition: Output<Any>? = null,
    public val deploymentPolicy: Output<ApplicationDeploymentPolicyArgs>? = null,
    public val description: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val isEnabled: Output<Boolean>? = null,
    public val location: Output<String>? = null,
    public val lockLevel: Output<ApplicationLockLevel>? = null,
    public val lockingPolicy: Output<ApplicationPackageLockingPolicyDefinitionArgs>? = null,
    public val mainTemplate: Output<Any>? = null,
    public val managedBy: Output<String>? = null,
    public val managementPolicy: Output<ApplicationManagementPolicyArgs>? = null,
    public val notificationPolicy: Output<ApplicationNotificationPolicyArgs>? = null,
    public val packageFileUri: Output<String>? = null,
    public val policies: Output<List<ApplicationPolicyArgs>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<SkuArgs>? = null,
    public val storageAccountId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.solutions.ApplicationDefinitionArgs> {
    override fun toJava(): com.pulumi.azurenative.solutions.ApplicationDefinitionArgs =
        com.pulumi.azurenative.solutions.ApplicationDefinitionArgs.builder()
            .applicationDefinitionName(applicationDefinitionName?.applyValue({ args0 -> args0 }))
            .artifacts(
                artifacts?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .authorizations(
                authorizations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .createUiDefinition(createUiDefinition?.applyValue({ args0 -> args0 }))
            .deploymentPolicy(deploymentPolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .isEnabled(isEnabled?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .lockLevel(lockLevel?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .lockingPolicy(lockingPolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .mainTemplate(mainTemplate?.applyValue({ args0 -> args0 }))
            .managedBy(managedBy?.applyValue({ args0 -> args0 }))
            .managementPolicy(managementPolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .notificationPolicy(
                notificationPolicy?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .packageFileUri(packageFileUri?.applyValue({ args0 -> args0 }))
            .policies(
                policies?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .storageAccountId(storageAccountId?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ApplicationDefinitionArgs].
 */
@PulumiTagMarker
public class ApplicationDefinitionArgsBuilder internal constructor() {
    private var applicationDefinitionName: Output<String>? = null

    private var artifacts: Output<List<ApplicationDefinitionArtifactArgs>>? = null

    private var authorizations: Output<List<ApplicationAuthorizationArgs>>? = null

    private var createUiDefinition: Output<Any>? = null

    private var deploymentPolicy: Output<ApplicationDeploymentPolicyArgs>? = null

    private var description: Output<String>? = null

    private var displayName: Output<String>? = null

    private var isEnabled: Output<Boolean>? = null

    private var location: Output<String>? = null

    private var lockLevel: Output<ApplicationLockLevel>? = null

    private var lockingPolicy: Output<ApplicationPackageLockingPolicyDefinitionArgs>? = null

    private var mainTemplate: Output<Any>? = null

    private var managedBy: Output<String>? = null

    private var managementPolicy: Output<ApplicationManagementPolicyArgs>? = null

    private var notificationPolicy: Output<ApplicationNotificationPolicyArgs>? = null

    private var packageFileUri: Output<String>? = null

    private var policies: Output<List<ApplicationPolicyArgs>>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<SkuArgs>? = null

    private var storageAccountId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the managed application definition.
     */
    @JvmName("obljvsrtniqpwtwx")
    public suspend fun applicationDefinitionName(`value`: Output<String>) {
        this.applicationDefinitionName = value
    }

    /**
     * @param value The collection of managed application artifacts. The portal will use the files specified as artifacts to construct the user experience of creating a managed application from a managed application definition.
     */
    @JvmName("lgvavrfotcmxjqjf")
    public suspend fun artifacts(`value`: Output<List<ApplicationDefinitionArtifactArgs>>) {
        this.artifacts = value
    }

    @JvmName("iqqupfufaehfxcfu")
    public suspend fun artifacts(vararg values: Output<ApplicationDefinitionArtifactArgs>) {
        this.artifacts = Output.all(values.asList())
    }

    /**
     * @param values The collection of managed application artifacts. The portal will use the files specified as artifacts to construct the user experience of creating a managed application from a managed application definition.
     */
    @JvmName("vgmsdsxedmqmacdb")
    public suspend fun artifacts(values: List<Output<ApplicationDefinitionArtifactArgs>>) {
        this.artifacts = Output.all(values)
    }

    /**
     * @param value The managed application provider authorizations.
     */
    @JvmName("dwwhatfwxcglyfnv")
    public suspend fun authorizations(`value`: Output<List<ApplicationAuthorizationArgs>>) {
        this.authorizations = value
    }

    @JvmName("qlxskbodierdalkq")
    public suspend fun authorizations(vararg values: Output<ApplicationAuthorizationArgs>) {
        this.authorizations = Output.all(values.asList())
    }

    /**
     * @param values The managed application provider authorizations.
     */
    @JvmName("ilerxekgywdytfjn")
    public suspend fun authorizations(values: List<Output<ApplicationAuthorizationArgs>>) {
        this.authorizations = Output.all(values)
    }

    /**
     * @param value The createUiDefinition json for the backing template with Microsoft.Solutions/applications resource. It can be a JObject or well-formed JSON string.
     */
    @JvmName("dgnjgmerudgfxryh")
    public suspend fun createUiDefinition(`value`: Output<Any>) {
        this.createUiDefinition = value
    }

    /**
     * @param value The managed application deployment policy.
     */
    @JvmName("qpoxfcwpsondehxv")
    public suspend fun deploymentPolicy(`value`: Output<ApplicationDeploymentPolicyArgs>) {
        this.deploymentPolicy = value
    }

    /**
     * @param value The managed application definition description.
     */
    @JvmName("vdoyeefulxnthjpu")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The managed application definition display name.
     */
    @JvmName("kvtrfovbdulpniqm")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value A value indicating whether the package is enabled or not.
     */
    @JvmName("vicadtbfacosokrk")
    public suspend fun isEnabled(`value`: Output<Boolean>) {
        this.isEnabled = value
    }

    /**
     * @param value Resource location
     */
    @JvmName("xaqkdijhplltidmx")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The managed application lock level.
     */
    @JvmName("lvaqyclqubypetpb")
    public suspend fun lockLevel(`value`: Output<ApplicationLockLevel>) {
        this.lockLevel = value
    }

    /**
     * @param value The managed application locking policy.
     */
    @JvmName("xtnfiftxwlgqnagy")
    public suspend fun lockingPolicy(`value`: Output<ApplicationPackageLockingPolicyDefinitionArgs>) {
        this.lockingPolicy = value
    }

    /**
     * @param value The inline main template json which has resources to be provisioned. It can be a JObject or well-formed JSON string.
     */
    @JvmName("grdrgtrjtacbglvs")
    public suspend fun mainTemplate(`value`: Output<Any>) {
        this.mainTemplate = value
    }

    /**
     * @param value ID of the resource that manages this resource.
     */
    @JvmName("krlblwylybnwiybv")
    public suspend fun managedBy(`value`: Output<String>) {
        this.managedBy = value
    }

    /**
     * @param value The managed application management policy that determines publisher's access to the managed resource group.
     */
    @JvmName("xacubswaciebenrv")
    public suspend fun managementPolicy(`value`: Output<ApplicationManagementPolicyArgs>) {
        this.managementPolicy = value
    }

    /**
     * @param value The managed application notification policy.
     */
    @JvmName("jwkccbhkhpicmdyn")
    public suspend fun notificationPolicy(`value`: Output<ApplicationNotificationPolicyArgs>) {
        this.notificationPolicy = value
    }

    /**
     * @param value The managed application definition package file Uri. Use this element
     */
    @JvmName("kgsdojssecfvarnt")
    public suspend fun packageFileUri(`value`: Output<String>) {
        this.packageFileUri = value
    }

    /**
     * @param value The managed application provider policies.
     */
    @JvmName("dbssleakqongrgwj")
    public suspend fun policies(`value`: Output<List<ApplicationPolicyArgs>>) {
        this.policies = value
    }

    @JvmName("feiofvcjhlgdbyle")
    public suspend fun policies(vararg values: Output<ApplicationPolicyArgs>) {
        this.policies = Output.all(values.asList())
    }

    /**
     * @param values The managed application provider policies.
     */
    @JvmName("syhtnnyopufgwnjh")
    public suspend fun policies(values: List<Output<ApplicationPolicyArgs>>) {
        this.policies = Output.all(values)
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("aubrtbuukkbapuax")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The SKU of the resource.
     */
    @JvmName("howhxfgagteufpup")
    public suspend fun sku(`value`: Output<SkuArgs>) {
        this.sku = value
    }

    /**
     * @param value The storage account id for bring your own storage scenario.
     */
    @JvmName("elbbarjsyhrfkruf")
    public suspend fun storageAccountId(`value`: Output<String>) {
        this.storageAccountId = value
    }

    /**
     * @param value Resource tags
     */
    @JvmName("xehmlgamskcrperv")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the managed application definition.
     */
    @JvmName("fltfvigyamxxjsnx")
    public suspend fun applicationDefinitionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationDefinitionName = mapped
    }

    /**
     * @param value The collection of managed application artifacts. The portal will use the files specified as artifacts to construct the user experience of creating a managed application from a managed application definition.
     */
    @JvmName("jnxjvaelvqgsjvdq")
    public suspend fun artifacts(`value`: List<ApplicationDefinitionArtifactArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.artifacts = mapped
    }

    /**
     * @param argument The collection of managed application artifacts. The portal will use the files specified as artifacts to construct the user experience of creating a managed application from a managed application definition.
     */
    @JvmName("cpalghvvnmqrhant")
    public suspend fun artifacts(argument: List<suspend ApplicationDefinitionArtifactArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ApplicationDefinitionArtifactArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.artifacts = mapped
    }

    /**
     * @param argument The collection of managed application artifacts. The portal will use the files specified as artifacts to construct the user experience of creating a managed application from a managed application definition.
     */
    @JvmName("vyahqjyxojiqkwwr")
    public suspend fun artifacts(vararg argument: suspend ApplicationDefinitionArtifactArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ApplicationDefinitionArtifactArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.artifacts = mapped
    }

    /**
     * @param argument The collection of managed application artifacts. The portal will use the files specified as artifacts to construct the user experience of creating a managed application from a managed application definition.
     */
    @JvmName("mduftjofeeasmdtm")
    public suspend fun artifacts(argument: suspend ApplicationDefinitionArtifactArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ApplicationDefinitionArtifactArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.artifacts = mapped
    }

    /**
     * @param values The collection of managed application artifacts. The portal will use the files specified as artifacts to construct the user experience of creating a managed application from a managed application definition.
     */
    @JvmName("adufbmrdvkcsxiin")
    public suspend fun artifacts(vararg values: ApplicationDefinitionArtifactArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.artifacts = mapped
    }

    /**
     * @param value The managed application provider authorizations.
     */
    @JvmName("syyycxcfhmpljerr")
    public suspend fun authorizations(`value`: List<ApplicationAuthorizationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizations = mapped
    }

    /**
     * @param argument The managed application provider authorizations.
     */
    @JvmName("sblhhvyrfkiylsbb")
    public suspend fun authorizations(argument: List<suspend ApplicationAuthorizationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ApplicationAuthorizationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.authorizations = mapped
    }

    /**
     * @param argument The managed application provider authorizations.
     */
    @JvmName("tertwqguwfxsuvaq")
    public suspend fun authorizations(vararg argument: suspend ApplicationAuthorizationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ApplicationAuthorizationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.authorizations = mapped
    }

    /**
     * @param argument The managed application provider authorizations.
     */
    @JvmName("mvlqwlylhfbpwebw")
    public suspend fun authorizations(argument: suspend ApplicationAuthorizationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ApplicationAuthorizationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.authorizations = mapped
    }

    /**
     * @param values The managed application provider authorizations.
     */
    @JvmName("pthdslmyspyuhihx")
    public suspend fun authorizations(vararg values: ApplicationAuthorizationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authorizations = mapped
    }

    /**
     * @param value The createUiDefinition json for the backing template with Microsoft.Solutions/applications resource. It can be a JObject or well-formed JSON string.
     */
    @JvmName("njgecxwtoqasvpwa")
    public suspend fun createUiDefinition(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.createUiDefinition = mapped
    }

    /**
     * @param value The managed application deployment policy.
     */
    @JvmName("auvetydxjoweuemk")
    public suspend fun deploymentPolicy(`value`: ApplicationDeploymentPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deploymentPolicy = mapped
    }

    /**
     * @param argument The managed application deployment policy.
     */
    @JvmName("mybvcssbmveayajd")
    public suspend fun deploymentPolicy(argument: suspend ApplicationDeploymentPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = ApplicationDeploymentPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.deploymentPolicy = mapped
    }

    /**
     * @param value The managed application definition description.
     */
    @JvmName("tdxmhiknsppwqsku")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The managed application definition display name.
     */
    @JvmName("ybififbowtcbjjtv")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value A value indicating whether the package is enabled or not.
     */
    @JvmName("dotfaussbjhmfkwh")
    public suspend fun isEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isEnabled = mapped
    }

    /**
     * @param value Resource location
     */
    @JvmName("dmkfamrwlhklidjs")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The managed application lock level.
     */
    @JvmName("fksisqhwowjtllai")
    public suspend fun lockLevel(`value`: ApplicationLockLevel?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lockLevel = mapped
    }

    /**
     * @param value The managed application locking policy.
     */
    @JvmName("llbkhflkvgjhmuep")
    public suspend fun lockingPolicy(`value`: ApplicationPackageLockingPolicyDefinitionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lockingPolicy = mapped
    }

    /**
     * @param argument The managed application locking policy.
     */
    @JvmName("uqldrtyrcctxrtop")
    public suspend fun lockingPolicy(argument: suspend ApplicationPackageLockingPolicyDefinitionArgsBuilder.() -> Unit) {
        val toBeMapped = ApplicationPackageLockingPolicyDefinitionArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.lockingPolicy = mapped
    }

    /**
     * @param value The inline main template json which has resources to be provisioned. It can be a JObject or well-formed JSON string.
     */
    @JvmName("tcirpwpcssxyiiam")
    public suspend fun mainTemplate(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mainTemplate = mapped
    }

    /**
     * @param value ID of the resource that manages this resource.
     */
    @JvmName("hxyhawbhbmuicjwe")
    public suspend fun managedBy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedBy = mapped
    }

    /**
     * @param value The managed application management policy that determines publisher's access to the managed resource group.
     */
    @JvmName("gtvexscjfnalqgcp")
    public suspend fun managementPolicy(`value`: ApplicationManagementPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managementPolicy = mapped
    }

    /**
     * @param argument The managed application management policy that determines publisher's access to the managed resource group.
     */
    @JvmName("iehxvatvhuvyxtck")
    public suspend fun managementPolicy(argument: suspend ApplicationManagementPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = ApplicationManagementPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.managementPolicy = mapped
    }

    /**
     * @param value The managed application notification policy.
     */
    @JvmName("bjkufsudwuqrwfso")
    public suspend fun notificationPolicy(`value`: ApplicationNotificationPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notificationPolicy = mapped
    }

    /**
     * @param argument The managed application notification policy.
     */
    @JvmName("selqxakccgbyrnxh")
    public suspend fun notificationPolicy(argument: suspend ApplicationNotificationPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = ApplicationNotificationPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.notificationPolicy = mapped
    }

    /**
     * @param value The managed application definition package file Uri. Use this element
     */
    @JvmName("xdgoxstyfogfmkfm")
    public suspend fun packageFileUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packageFileUri = mapped
    }

    /**
     * @param value The managed application provider policies.
     */
    @JvmName("icderkccasitdkti")
    public suspend fun policies(`value`: List<ApplicationPolicyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policies = mapped
    }

    /**
     * @param argument The managed application provider policies.
     */
    @JvmName("phrgvqrblgqkxgrv")
    public suspend fun policies(argument: List<suspend ApplicationPolicyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ApplicationPolicyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.policies = mapped
    }

    /**
     * @param argument The managed application provider policies.
     */
    @JvmName("sunjajrradgacsdk")
    public suspend fun policies(vararg argument: suspend ApplicationPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ApplicationPolicyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.policies = mapped
    }

    /**
     * @param argument The managed application provider policies.
     */
    @JvmName("eknyirylenqelfbs")
    public suspend fun policies(argument: suspend ApplicationPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ApplicationPolicyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.policies = mapped
    }

    /**
     * @param values The managed application provider policies.
     */
    @JvmName("kvxxpnpokljgpltf")
    public suspend fun policies(vararg values: ApplicationPolicyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.policies = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("rtfffotdaogddsge")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The SKU of the resource.
     */
    @JvmName("ukusnxudllsdunhs")
    public suspend fun sku(`value`: SkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument The SKU of the resource.
     */
    @JvmName("ihoylxhbsvyrpbfm")
    public suspend fun sku(argument: suspend SkuArgsBuilder.() -> Unit) {
        val toBeMapped = SkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value The storage account id for bring your own storage scenario.
     */
    @JvmName("utasvaluwieynnkg")
    public suspend fun storageAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountId = mapped
    }

    /**
     * @param value Resource tags
     */
    @JvmName("xnaoakjlgxwiimyy")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags
     */
    @JvmName("ohoywlngmiqkoudd")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ApplicationDefinitionArgs = ApplicationDefinitionArgs(
        applicationDefinitionName = applicationDefinitionName,
        artifacts = artifacts,
        authorizations = authorizations,
        createUiDefinition = createUiDefinition,
        deploymentPolicy = deploymentPolicy,
        description = description,
        displayName = displayName,
        isEnabled = isEnabled,
        location = location,
        lockLevel = lockLevel,
        lockingPolicy = lockingPolicy,
        mainTemplate = mainTemplate,
        managedBy = managedBy,
        managementPolicy = managementPolicy,
        notificationPolicy = notificationPolicy,
        packageFileUri = packageFileUri,
        policies = policies,
        resourceGroupName = resourceGroupName,
        sku = sku,
        storageAccountId = storageAccountId,
        tags = tags,
    )
}
