@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.solutions.kotlin

import com.pulumi.azurenative.solutions.kotlin.outputs.ApplicationClientDetailsResponse
import com.pulumi.azurenative.solutions.kotlin.outputs.JitAuthorizationPoliciesResponse
import com.pulumi.azurenative.solutions.kotlin.outputs.JitSchedulingPolicyResponse
import com.pulumi.azurenative.solutions.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.solutions.kotlin.outputs.ApplicationClientDetailsResponse.Companion.toKotlin as applicationClientDetailsResponseToKotlin
import com.pulumi.azurenative.solutions.kotlin.outputs.JitAuthorizationPoliciesResponse.Companion.toKotlin as jitAuthorizationPoliciesResponseToKotlin
import com.pulumi.azurenative.solutions.kotlin.outputs.JitSchedulingPolicyResponse.Companion.toKotlin as jitSchedulingPolicyResponseToKotlin
import com.pulumi.azurenative.solutions.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [JitRequest].
 */
@PulumiTagMarker
public class JitRequestResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: JitRequestArgs = JitRequestArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend JitRequestArgsBuilder.() -> Unit) {
        val builder = JitRequestArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): JitRequest {
        val builtJavaResource = com.pulumi.azurenative.solutions.JitRequest(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return JitRequest(builtJavaResource)
    }
}

/**
 * Information about JIT request definition.
 * Azure REST API version: 2021-07-01. Prior API version in Azure Native 1.x: 2019-07-01.
 * Other available API versions: 2023-12-01-preview.
 * ## Example Usage
 * ### Create or update jit request
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var jitRequest = new AzureNative.Solutions.JitRequest("jitRequest", new()
 *     {
 *         ApplicationResourceId = "/subscriptions/00c76877-e316-48a7-af60-4a09fec9d43f/resourceGroups/52F30DB2/providers/Microsoft.Solutions/applications/7E193158",
 *         JitAuthorizationPolicies = new[]
 *         {
 *             new AzureNative.Solutions.Inputs.JitAuthorizationPoliciesArgs
 *             {
 *                 PrincipalId = "1db8e132e2934dbcb8e1178a61319491",
 *                 RoleDefinitionId = "ecd05a23-931a-4c38-a52b-ac7c4c583334",
 *             },
 *         },
 *         JitRequestName = "myJitRequest",
 *         JitSchedulingPolicy = new AzureNative.Solutions.Inputs.JitSchedulingPolicyArgs
 *         {
 *             Duration = "PT8H",
 *             StartTime = "2021-04-22T05:48:30.6661804Z",
 *             Type = AzureNative.Solutions.JitSchedulingType.Once,
 *         },
 *         ResourceGroupName = "rg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/solutions/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := solutions.NewJitRequest(ctx, "jitRequest", &solutions.JitRequestArgs{
 * 			ApplicationResourceId: pulumi.String("/subscriptions/00c76877-e316-48a7-af60-4a09fec9d43f/resourceGroups/52F30DB2/providers/Microsoft.Solutions/applications/7E193158"),
 * 			JitAuthorizationPolicies: solutions.JitAuthorizationPoliciesArray{
 * 				&solutions.JitAuthorizationPoliciesArgs{
 * 					PrincipalId:      pulumi.String("1db8e132e2934dbcb8e1178a61319491"),
 * 					RoleDefinitionId: pulumi.String("ecd05a23-931a-4c38-a52b-ac7c4c583334"),
 * 				},
 * 			},
 * 			JitRequestName: pulumi.String("myJitRequest"),
 * 			JitSchedulingPolicy: &solutions.JitSchedulingPolicyArgs{
 * 				Duration:  pulumi.String("PT8H"),
 * 				StartTime: pulumi.String("2021-04-22T05:48:30.6661804Z"),
 * 				Type:      pulumi.String(solutions.JitSchedulingTypeOnce),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.solutions.JitRequest;
 * import com.pulumi.azurenative.solutions.JitRequestArgs;
 * import com.pulumi.azurenative.solutions.inputs.JitAuthorizationPoliciesArgs;
 * import com.pulumi.azurenative.solutions.inputs.JitSchedulingPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var jitRequest = new JitRequest("jitRequest", JitRequestArgs.builder()
 *             .applicationResourceId("/subscriptions/00c76877-e316-48a7-af60-4a09fec9d43f/resourceGroups/52F30DB2/providers/Microsoft.Solutions/applications/7E193158")
 *             .jitAuthorizationPolicies(JitAuthorizationPoliciesArgs.builder()
 *                 .principalId("1db8e132e2934dbcb8e1178a61319491")
 *                 .roleDefinitionId("ecd05a23-931a-4c38-a52b-ac7c4c583334")
 *                 .build())
 *             .jitRequestName("myJitRequest")
 *             .jitSchedulingPolicy(JitSchedulingPolicyArgs.builder()
 *                 .duration("PT8H")
 *                 .startTime("2021-04-22T05:48:30.6661804Z")
 *                 .type("Once")
 *                 .build())
 *             .resourceGroupName("rg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:solutions:JitRequest myJitRequest /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Solutions/jitRequests/{jitRequestName}
 * ```
 */
public class JitRequest internal constructor(
    override val javaResource: com.pulumi.azurenative.solutions.JitRequest,
) : KotlinCustomResource(javaResource, JitRequestMapper) {
    /**
     * The parent application id.
     */
    public val applicationResourceId: Output<String>
        get() = javaResource.applicationResourceId().applyValue({ args0 -> args0 })

    /**
     * The client entity that created the JIT request.
     */
    public val createdBy: Output<ApplicationClientDetailsResponse>
        get() = javaResource.createdBy().applyValue({ args0 ->
            args0.let({ args0 ->
                applicationClientDetailsResponseToKotlin(args0)
            })
        })

    /**
     * The JIT authorization policies.
     */
    public val jitAuthorizationPolicies: Output<List<JitAuthorizationPoliciesResponse>>
        get() = javaResource.jitAuthorizationPolicies().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> jitAuthorizationPoliciesResponseToKotlin(args0) })
            })
        })

    /**
     * The JIT request state.
     */
    public val jitRequestState: Output<String>
        get() = javaResource.jitRequestState().applyValue({ args0 -> args0 })

    /**
     * The JIT request properties.
     */
    public val jitSchedulingPolicy: Output<JitSchedulingPolicyResponse>
        get() = javaResource.jitSchedulingPolicy().applyValue({ args0 ->
            args0.let({ args0 ->
                jitSchedulingPolicyResponseToKotlin(args0)
            })
        })

    /**
     * Resource location
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The JIT request provisioning state.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The publisher tenant id.
     */
    public val publisherTenantId: Output<String>
        get() = javaResource.publisherTenantId().applyValue({ args0 -> args0 })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The client entity that last updated the JIT request.
     */
    public val updatedBy: Output<ApplicationClientDetailsResponse>
        get() = javaResource.updatedBy().applyValue({ args0 ->
            args0.let({ args0 ->
                applicationClientDetailsResponseToKotlin(args0)
            })
        })
}

public object JitRequestMapper : ResourceMapper<JitRequest> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.solutions.JitRequest::class == javaResource::class

    override fun map(javaResource: Resource): JitRequest = JitRequest(
        javaResource as
            com.pulumi.azurenative.solutions.JitRequest,
    )
}

/**
 * @see [JitRequest].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [JitRequest].
 */
public suspend fun jitRequest(name: String, block: suspend JitRequestResourceBuilder.() -> Unit): JitRequest {
    val builder = JitRequestResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [JitRequest].
 * @param name The _unique_ name of the resulting resource.
 */
public fun jitRequest(name: String): JitRequest {
    val builder = JitRequestResourceBuilder()
    builder.name(name)
    return builder.build()
}
