@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.solutions.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The managed application deployment mode.
 */
public enum class DeploymentMode(
    public val javaValue: com.pulumi.azurenative.solutions.enums.DeploymentMode,
) : ConvertibleToJava<com.pulumi.azurenative.solutions.enums.DeploymentMode> {
    NotSpecified(com.pulumi.azurenative.solutions.enums.DeploymentMode.NotSpecified),
    Incremental(com.pulumi.azurenative.solutions.enums.DeploymentMode.Incremental),
    Complete(com.pulumi.azurenative.solutions.enums.DeploymentMode.Complete),
    ;

    override fun toJava(): com.pulumi.azurenative.solutions.enums.DeploymentMode = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.solutions.enums.DeploymentMode): DeploymentMode = DeploymentMode.values().first { it.javaValue == javaType }
    }
}
