@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.solutions.kotlin.inputs

import com.pulumi.azurenative.solutions.inputs.ApplicationDefinitionArtifactArgs.builder
import com.pulumi.azurenative.solutions.kotlin.enums.ApplicationArtifactType
import com.pulumi.azurenative.solutions.kotlin.enums.ApplicationDefinitionArtifactName
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Application definition artifact.
 * @property name The managed application definition artifact name.
 * @property type The managed application definition artifact type.
 * @property uri The managed application definition artifact blob uri.
 */
public data class ApplicationDefinitionArtifactArgs(
    public val name: Output<Either<String, ApplicationDefinitionArtifactName>>,
    public val type: Output<ApplicationArtifactType>,
    public val uri: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.solutions.inputs.ApplicationDefinitionArtifactArgs> {
    override fun toJava(): com.pulumi.azurenative.solutions.inputs.ApplicationDefinitionArtifactArgs =
        com.pulumi.azurenative.solutions.inputs.ApplicationDefinitionArtifactArgs.builder()
            .name(
                name.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .type(type.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .uri(uri.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationDefinitionArtifactArgs].
 */
@PulumiTagMarker
public class ApplicationDefinitionArtifactArgsBuilder internal constructor() {
    private var name: Output<Either<String, ApplicationDefinitionArtifactName>>? = null

    private var type: Output<ApplicationArtifactType>? = null

    private var uri: Output<String>? = null

    /**
     * @param value The managed application definition artifact name.
     */
    @JvmName("bolpdbnvxginmaik")
    public suspend fun name(`value`: Output<Either<String, ApplicationDefinitionArtifactName>>) {
        this.name = value
    }

    /**
     * @param value The managed application definition artifact type.
     */
    @JvmName("hviqpamksvdvnruk")
    public suspend fun type(`value`: Output<ApplicationArtifactType>) {
        this.type = value
    }

    /**
     * @param value The managed application definition artifact blob uri.
     */
    @JvmName("lhhmlipupfvvkoof")
    public suspend fun uri(`value`: Output<String>) {
        this.uri = value
    }

    /**
     * @param value The managed application definition artifact name.
     */
    @JvmName("mfwvtiravroryari")
    public suspend fun name(`value`: Either<String, ApplicationDefinitionArtifactName>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The managed application definition artifact name.
     */
    @JvmName("unaannfljquvyimp")
    public fun name(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ApplicationDefinitionArtifactName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The managed application definition artifact name.
     */
    @JvmName("nslvtrawpesvfafv")
    public fun name(`value`: ApplicationDefinitionArtifactName) {
        val toBeMapped = Either.ofRight<String, ApplicationDefinitionArtifactName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The managed application definition artifact type.
     */
    @JvmName("uxjwdweflqpretve")
    public suspend fun type(`value`: ApplicationArtifactType) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The managed application definition artifact blob uri.
     */
    @JvmName("thpncjlnwywexgbm")
    public suspend fun uri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.uri = mapped
    }

    internal fun build(): ApplicationDefinitionArtifactArgs = ApplicationDefinitionArtifactArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        type = type ?: throw PulumiNullFieldException("type"),
        uri = uri ?: throw PulumiNullFieldException("uri"),
    )
}
